package com.zurrtum.create.client.content.kinetics.crank;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlock;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlockEntity;
import net.minecraft.class_11683;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class HandCrankRenderer extends KineticBlockEntityRenderer<HandCrankBlockEntity, HandCrankRenderer.HandCrankRenderState> {
    public HandCrankRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public HandCrankRenderState createRenderState() {
        return new HandCrankRenderState();
    }

    @Override
    public void extractRenderState(
        HandCrankBlockEntity be,
        HandCrankRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        if (shouldRenderShaft()) {
            super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
            if (state.support) {
                return;
            }
        } else {
            class_1937 world = be.method_10997();
            state.support = VisualizationManager.supportsVisualization(world);
            if (state.support) {
                return;
            }
            updateBaseRenderState(be, state, world, crumblingOverlay);
        }
        state.handle = getRenderedHandle(state.blockState);
        state.handleAngle = AngleHelper.rad(getIndependentAngle(be, tickProgress));
    }

    @Override
    protected class_1921 getRenderType(HandCrankBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    /**
     * In degrees
     */
    public float getIndependentAngle(HandCrankBlockEntity be, float partialTicks) {
        return getHandCrankIndependentAngle(be, partialTicks);
    }

    public static float getHandCrankIndependentAngle(HandCrankBlockEntity be, float partialTicks) {
        return be.independentAngle + partialTicks * be.chasingAngularVelocity;
    }

    public SuperByteBuffer getRenderedHandle(class_2680 blockState) {
        class_2350 facing = blockState.method_28500(HandCrankBlock.FACING).orElse(class_2350.field_11036);
        return CachedBuffers.partialFacing(AllPartialModels.HAND_CRANK_HANDLE, blockState, facing.method_10153());
    }

    public boolean shouldRenderShaft() {
        return true;
    }

    public static class HandCrankRenderState extends KineticRenderState {
        public SuperByteBuffer handle;
        public float handleAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (model != null) {
                super.render(matricesEntry, vertexConsumer);
            }
            handle.light(lightCoords);
            handle.rotateCentered(handleAngle, direction);
            handle.color(color);
            handle.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
