package com.zurrtum.create.client.content.kinetics.flywheel;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.flywheel.FlywheelBlockEntity;
import net.minecraft.class_11683;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class FlywheelRenderer extends KineticBlockEntityRenderer<FlywheelBlockEntity, FlywheelRenderer.FlywheelRenderState> {
    public FlywheelRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public FlywheelRenderState createRenderState() {
        return new FlywheelRenderState();
    }

    @Override
    public void extractRenderState(
        FlywheelBlockEntity be,
        FlywheelRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_2680 blockState = be.method_11010();
        state.wheel = CachedBuffers.block(blockState);
        float speed = be.visualSpeed.getValue(tickProgress) * 3 / 10f;
        state.wheelAngle = AngleHelper.rad(be.angle + speed * tickProgress);
    }

    @Override
    protected class_1921 getRenderType(FlywheelBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    @Override
    protected class_2680 getRenderedBlockState(FlywheelBlockEntity be) {
        return shaft(getRotationAxisOf(be));
    }

    public static class FlywheelRenderState extends KineticRenderState {
        public SuperByteBuffer wheel;
        public float wheelAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            wheel.light(lightCoords).rotateCentered(wheelAngle, direction).color(color).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
