package com.zurrtum.create.client.content.kinetics.gearbox;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class GearboxRenderer implements class_827<GearboxBlockEntity, GearboxRenderer.GearboxRenderState> {
    public GearboxRenderer(class_5614.class_5615 context) {
    }

    @Override
    public GearboxRenderState method_74335() {
        return new GearboxRenderState();
    }

    @Override
    public void extractRenderState(
        GearboxBlockEntity be,
        GearboxRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_12249.method_75965();
        class_2351 boxAxis = state.field_62674.method_11654(class_2741.field_12496);
        class_2338 pos = state.field_62673;
        float time = AnimationTickHolder.getRenderTime(be.method_10997());
        float speed = be.getSpeed();
        class_2338 source = null;
        class_2350 sourceFacing = null;
        if (speed != 0 && be.source != null) {
            source = be.source.method_10059(state.field_62673);
            sourceFacing = class_2350.method_10147(source.method_10263(), source.method_10264(), source.method_10260());
        }
        state.color = KineticBlockEntityRenderer.getColor(be);
        float angle = (time * speed * 3f / 10) % 360;
        if (boxAxis != class_2351.field_11052) {
            float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, class_2351.field_11052);
            state.down = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11033);
            state.downAngle = getAngle(angle, offset, class_2350.field_11033, source, sourceFacing);
            state.up = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11036);
            state.upAngle = getAngle(angle, offset, class_2350.field_11036, source, sourceFacing);
        }
        if (boxAxis != class_2351.field_11051) {
            float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, class_2351.field_11051);
            state.north = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11043);
            state.northAngle = getAngle(angle, offset, class_2350.field_11043, source, sourceFacing);
            state.south = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11035);
            state.southAngle = getAngle(angle, offset, class_2350.field_11035, source, sourceFacing);
        }
        if (boxAxis != class_2351.field_11048) {
            float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, class_2351.field_11048);
            state.west = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11039);
            state.westAngle = getAngle(angle, offset, class_2350.field_11039, source, sourceFacing);
            state.east = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, class_2350.field_11034);
            state.eastAngle = getAngle(angle, offset, class_2350.field_11034, source, sourceFacing);
        }
    }

    private static float getAngle(float angle, float offset, class_2350 direction, class_2338 source, class_2350 sourceFacing) {
        if (source != null) {
            if (sourceFacing.method_10166() == direction.method_10166())
                angle *= sourceFacing == direction ? 1 : -1;
            else if (sourceFacing.method_10171() == direction.method_10171())
                angle *= -1;
        }
        angle += offset;
        return angle / 180f * (float) Math.PI;
    }

    @Override
    public void submit(GearboxRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    public static class GearboxRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public Color color;
        public SuperByteBuffer down;
        public float downAngle;
        public SuperByteBuffer up;
        public float upAngle;
        public SuperByteBuffer north;
        public float northAngle;
        public SuperByteBuffer south;
        public float southAngle;
        public SuperByteBuffer west;
        public float westAngle;
        public SuperByteBuffer east;
        public float eastAngle;

        private void render(SuperByteBuffer model, float angle, class_2350 axis, class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.light(field_62676);
            model.rotateCentered(angle, axis);
            model.color(color);
            model.renderInto(matricesEntry, vertexConsumer);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (down != null) {
                render(down, downAngle, class_2350.field_11036, matricesEntry, vertexConsumer);
                render(up, upAngle, class_2350.field_11036, matricesEntry, vertexConsumer);
            }
            if (north != null) {
                render(north, northAngle, class_2350.field_11035, matricesEntry, vertexConsumer);
                render(south, southAngle, class_2350.field_11035, matricesEntry, vertexConsumer);
            }
            if (west != null) {
                render(west, westAngle, class_2350.field_11034, matricesEntry, vertexConsumer);
                render(east, eastAngle, class_2350.field_11034, matricesEntry, vertexConsumer);
            }
        }
    }
}
