package com.zurrtum.create.client.content.logistics.box;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5617;
import net.minecraft.class_7923;
import net.minecraft.class_897;

public class PackageRenderer extends class_897<PackageEntity, PackageRenderer.PackageState> {
    public PackageRenderer(class_5617.class_5618 pContext) {
        super(pContext);
        field_4673 = 0.5f;
    }

    @Override
    public PackageState method_55269() {
        return new PackageState();
    }

    @Override
    public void extractRenderState(PackageEntity entity, PackageState state, float tickProgress) {
        super.method_62354(entity, state, tickProgress);
        if (VisualizationManager.supportsVisualization(entity.method_73183())) {
            return;
        }
        class_1799 box = entity.box;
        if (box.method_7960() || !PackageItem.isPackage(box)) {
            box = AllItems.CARDBOARD_BLOCK.method_7854();
        }
        PartialModel model = AllPartialModels.PACKAGES.get(class_7923.field_41178.method_10221(box.method_7909()));
        if (model == null) {
            return;
        }
        int id = entity.method_5628();
        float yaw = entity.method_61415(tickProgress);
        state.box = getBoxRenderState(id, yaw, state.field_61820, model);
    }

    @Override
    public void submit(PackageState state, class_4587 ms, class_11659 queue, class_12075 cameraState) {
        if (state.box != null) {
            state.box.render(ms, queue);
        }
        super.method_3936(state, ms, queue, cameraState);
    }

    public static BoxRenderState getBoxRenderState(int id, float yaw, int light, PartialModel model) {
        BoxRenderState state = new BoxRenderState();
        state.layer = class_12249.method_75965();
        state.model = CachedBuffers.partial(model, class_2246.field_10124.method_9564());
        state.angle = -AngleHelper.rad(yaw + 90);
        state.nudge = id;
        state.light = light;
        return state;
    }

    public static class PackageState extends class_10017 {
        public BoxRenderState box;
    }

    public static class BoxRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public float angle;
        public int nudge;
        public int light;

        public void render(class_4587 ms, class_11659 queue) {
            queue.method_73483(ms, layer, this);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.translate(-.5, 0, -.5).rotateCentered(angle, class_2350.field_11036).light(light).nudge(nudge).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
