package com.zurrtum.create.client.content.logistics.depot;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.depot.DepotBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class DepotRenderer implements class_827<DepotBlockEntity, DepotRenderer.DepotRenderState> {
    protected final class_10442 itemModelManager;

    public DepotRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    public DepotRenderState method_74335() {
        return new DepotRenderState();
    }

    @Override
    public void extractRenderState(
        DepotBlockEntity be,
        DepotRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        state.field_62673 = be.method_11016();
        state.field_62675 = be.method_11017();
        class_1937 world = be.method_10997();
        state.field_62676 = world != null ? class_761.method_23794(world, state.field_62673) : class_765.field_32767;
        DepotBehaviour depotBehaviour = be.depotBehaviour;
        state.incoming = createIncomingStateList(depotBehaviour, itemModelManager, tickProgress, world);
        state.outputs = createOutputStateList(depotBehaviour, itemModelManager, world);
    }

    @Nullable
    public static DepotItemState[] createIncomingStateList(
        DepotBehaviour depotBehaviour,
        class_10442 itemModelManager,
        float tickProgress,
        class_1937 world
    ) {
        List<TransportedItemStack> incomingList = depotBehaviour.incoming;
        int incomingSize = incomingList.size();
        TransportedItemStack heldItem = depotBehaviour.heldItem;
        boolean notHeld = heldItem == null;
        if (incomingSize == 0 && notHeld) {
            return null;
        }
        DepotItemState[] incoming = new DepotItemState[notHeld ? incomingSize : incomingSize + 1];
        for (int i = 0; i < incomingSize; i++) {
            incoming[i] = DepotItemState.create(itemModelManager, incomingList.get(i), tickProgress, world);
        }
        if (!notHeld) {
            incoming[incomingSize] = DepotItemState.create(itemModelManager, heldItem, tickProgress, world);
        }
        return incoming;
    }

    @Nullable
    public static List<DepotOutputItemState> createOutputStateList(DepotBehaviour depotBehaviour, class_10442 itemModelManager, class_1937 world) {
        List<DepotOutputItemState> outputs = null;
        for (class_1799 stack : depotBehaviour.processingOutputBuffer) {
            if (stack.method_7960()) {
                continue;
            }
            if (outputs == null) {
                outputs = new ArrayList<>();
            }
            outputs.add(DepotOutputItemState.create(itemModelManager, stack, world));
        }
        return outputs;
    }

    @Override
    public void submit(DepotRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.incoming != null || state.outputs != null) {
            renderItemsOf(state.incoming, state.outputs, state.field_62673, cameraState.field_63078, queue, matrices, state.field_62676);
        }
    }

    public static void renderItemsOf(
        DepotItemState[] incoming,
        List<DepotOutputItemState> outputs,
        class_2338 pos,
        class_243 cameraPos,
        class_11659 queue,
        class_4587 ms,
        int light
    ) {
        var msr = TransformStack.of(ms);
        class_243 itemPosition = VecHelper.getCenterOf(pos);

        ms.method_22903();
        ms.method_46416(.5f, 15 / 16f, .5f);

        // Render main items
        if (incoming != null) {
            for (DepotItemState item : incoming) {
                ms.method_22903();
                msr.nudge(0);

                if (item.offset != null) {
                    ms.method_22904(item.offset.field_1352, item.offset.field_1351, item.offset.field_1350);
                }

                renderItem(
                    queue,
                    ms,
                    light,
                    item.state,
                    item.angle,
                    item.upright,
                    item.box,
                    item.count,
                    new Random(0),
                    itemPosition,
                    cameraPos,
                    false,
                    null
                );
                ms.method_22909();
            }
        }

        // Render output items
        if (outputs != null) {
            for (int i = 0, size = outputs.size(); i < size; i++) {
                DepotOutputItemState item = outputs.get(i);
                ms.method_22903();
                msr.nudge(i);

                boolean renderUpright = item.upright;
                msr.rotateYDegrees(360 / 8f * i);
                ms.method_46416(.35f, 0, 0);
                if (renderUpright)
                    msr.rotateYDegrees(-(360 / 8f * i));
                Random r = new Random(i + 1);
                int angle = (int) (360 * r.nextFloat());
                renderItem(
                    queue,
                    ms,
                    light,
                    item.state,
                    renderUpright ? angle + 90 : angle,
                    item.upright,
                    item.box,
                    item.count,
                    r,
                    itemPosition,
                    cameraPos,
                    false,
                    null
                );
                ms.method_22909();
            }
        }

        ms.method_22909();
    }

    public static void renderItem(
        class_11659 queue,
        class_4587 ms,
        int light,
        class_10444 state,
        int angle,
        boolean upright,
        boolean box,
        int count,
        Random r,
        class_243 itemPosition,
        class_243 cameraPos,
        boolean alwaysUpright,
        BiConsumer<PoseTransformStack, Boolean> transform
    ) {
        boolean blockItem = state.method_65608();
        var msr = TransformStack.of(ms);
        if (transform != null) {
            transform.accept(msr, blockItem);
        }
        boolean renderUpright = upright || alwaysUpright && !blockItem;

        ms.method_22903();
        msr.rotateYDegrees(angle);

        if (renderUpright) {
            class_243 diff = itemPosition.method_1020(cameraPos);
            float yRot = (float) (class_3532.method_15349(diff.field_1352, diff.field_1350) + Math.PI);
            ms.method_22907(class_7833.field_40716.rotation(yRot));
            ms.method_22904(0, 3 / 32d, -1 / 16f);
        }

        for (int i = 0; i <= count; i++) {
            ms.method_22903();
            if (blockItem && r != null)
                ms.method_46416(r.nextFloat() * .0625f * i, 0, r.nextFloat() * .0625f * i);

            if (box && !alwaysUpright) {
                ms.method_46416(0, 4 / 16f, 0);
                ms.method_22905(1.5f, 1.5f, 1.5f);
            } else if (blockItem && alwaysUpright) {
                ms.method_46416(0, 1 / 16f, 0);
                ms.method_22905(.755f, .755f, .755f);
            } else
                ms.method_22905(.5f, .5f, .5f);

            if (!blockItem && !renderUpright) {
                ms.method_46416(0, -3 / 16f, 0);
                msr.rotateXDegrees(90);
            }
            state.method_65604(ms, queue, light, class_4608.field_21444, 0);
            ms.method_22909();

            if (!renderUpright) {
                if (!blockItem)
                    msr.rotateYDegrees(10);
                ms.method_22904(0, blockItem ? 1 / 64d : 1 / 16d, 0);
            } else
                ms.method_46416(0, 0, -1 / 16f);
        }

        ms.method_22909();
    }

    public static class DepotRenderState extends class_11954 {
        public DepotItemState[] incoming;
        public List<DepotOutputItemState> outputs;
    }

    public record DepotItemState(class_10444 state, int angle, class_243 offset, boolean upright, boolean box, int count) {
        public static DepotItemState create(class_10442 itemModelManager, TransportedItemStack tis, float partialTicks, class_1937 world) {
            class_243 offsetVec;
            if (tis.insertedFrom.method_10166().method_10179()) {
                float offset = class_3532.method_16439(partialTicks, tis.prevBeltPosition, tis.beltPosition);
                float sideOffset = class_3532.method_16439(partialTicks, tis.prevSideOffset, tis.sideOffset);
                boolean alongX = tis.insertedFrom.method_10170().method_10166() == class_2350.class_2351.field_11048;
                if (!alongX)
                    sideOffset *= -1;
                offsetVec = class_243.method_24954(tis.insertedFrom.method_10153().method_62675()).method_1021(.5f - offset)
                    .method_1031(alongX ? sideOffset : 0, 0, alongX ? 0 : sideOffset);
            } else {
                offsetVec = null;
            }
            class_1799 stack = tis.stack;
            class_10444 state = new class_10444();
            state.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
            boolean upright = BeltHelper.isItemUpright(stack);
            boolean box = PackageItem.isPackage(stack);
            int count = class_3532.method_15351(stack.method_7947()) / 2;
            return new DepotItemState(state, tis.angle, offsetVec, upright, box, count);
        }
    }

    public record DepotOutputItemState(class_10444 state, boolean upright, boolean box, int count) {
        public static DepotOutputItemState create(class_10442 itemModelManager, class_1799 stack, class_1937 world) {
            class_10444 state = new class_10444();
            state.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
            boolean upright = BeltHelper.isItemUpright(stack);
            boolean box = PackageItem.isPackage(stack);
            int count = class_3532.method_15351(stack.method_7947()) / 2;
            return new DepotOutputItemState(state, upright, box, count);
        }
    }
}
