package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.factoryBoard.*;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.FactoryPanelConnectionPacket;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239.class_240;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class FactoryPanelConnectionHandler {

    static FactoryPanelPosition connectingFrom;
    static class_238 connectingFromBox;

    static boolean relocating;
    static FactoryPanelPosition validRelocationTarget;

    public static boolean panelClicked(class_1936 level, class_1657 player, ServerFactoryPanelBehaviour panel) {
        if (connectingFrom == null)
            return false;

        ServerFactoryPanelBehaviour at = ServerFactoryPanelBehaviour.at(level, connectingFrom);
        if (panel.getPanelPosition().equals(connectingFrom) || at == null) {
            player.method_7353(class_2561.method_43473(), true);
            connectingFrom = null;
            connectingFromBox = null;
            return true;
        }

        String checkForIssues = checkForIssues(at, panel);
        if (checkForIssues != null) {
            player.method_7353(CreateLang.translate(checkForIssues).style(class_124.field_1061).component(), true);
            connectingFrom = null;
            connectingFromBox = null;
            AllSoundEvents.DENY.playAt(player.method_73183(), player.method_24515(), 1, 1, false);
            return true;
        }

        class_1799 filterFrom = panel.getFilter();
        class_1799 filterTo = at.getFilter();

        ((class_746) player).field_3944.method_52787(new FactoryPanelConnectionPacket(panel.getPanelPosition(), connectingFrom, false));

        player.method_7353(
            CreateLang.translate("factory_panel.panels_connected", filterFrom.method_7964().getString(), filterTo.method_7964().getString())
                .style(class_124.field_1060).component(), true
        );

        connectingFrom = null;
        connectingFromBox = null;
        player.method_73183().method_45446(player.method_24515(), class_3417.field_26940, class_3419.field_15245, 0.5f, 0.5f, false);

        return true;
    }

    @Nullable
    private static String checkForIssues(ServerFactoryPanelBehaviour from, ServerFactoryPanelBehaviour to) {
        if (from == null)
            return "factory_panel.connection_aborted";
        if (from.targetedBy.containsKey(to.getPanelPosition()))
            return "factory_panel.already_connected";
        if (from.targetedBy.size() >= 9)
            return "factory_panel.cannot_add_more_inputs";

        class_2680 state1 = to.blockEntity.method_11010();
        class_2680 state2 = from.blockEntity.method_11010();
        class_2338 diff = to.getPos().method_10059(from.getPos());

        if (state1.method_11657(FactoryPanelBlock.WATERLOGGED, false)
            .method_11657(FactoryPanelBlock.POWERED, false) != state2.method_11657(FactoryPanelBlock.WATERLOGGED, false)
            .method_11657(FactoryPanelBlock.POWERED, false))
            return "factory_panel.same_orientation";

        if (FactoryPanelBlock.connectedDirection(state1).method_10166().method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260()) != 0)
            return "factory_panel.same_surface";

        if (!diff.method_19771(class_2338.field_10980, 16))
            return "factory_panel.too_far_apart";

        if (to.panelBE().restocker)
            return "factory_panel.input_in_restock_mode";

        if (to.getFilter().method_7960() || from.getFilter().method_7960())
            return "factory_panel.no_item";

        return null;
    }

    @Nullable
    private static String checkForIssues(ServerFactoryPanelBehaviour from, FactoryPanelSupportBehaviour to) {
        if (from == null)
            return "factory_panel.connection_aborted";

        class_2680 state1 = from.blockEntity.method_11010();
        class_2680 state2 = to.blockEntity.method_11010();
        class_2338 diff = to.getPos().method_10059(from.getPos());
        class_2350 connectedDirection = FactoryPanelBlock.connectedDirection(state1);

        if (connectedDirection != state2.method_61767(WrenchableDirectionalBlock.field_10927, connectedDirection))
            return "factory_panel.same_orientation";

        if (connectedDirection.method_10166().method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260()) != 0)
            return "factory_panel.same_surface";

        if (!diff.method_19771(class_2338.field_10980, 16))
            return "factory_panel.too_far_apart";

        return null;
    }

    public static void clientTick(class_310 mc) {
        if (connectingFrom == null || connectingFromBox == null)
            return;

        class_638 world = mc.field_1687;
        ServerFactoryPanelBehaviour at = ServerFactoryPanelBehaviour.at(world, connectingFrom);

        if (!connectingFrom.pos().method_19771(mc.field_1724.method_24515(), 16) || at == null) {
            connectingFrom = null;
            connectingFromBox = null;
            mc.field_1724.method_7353(class_2561.method_43473(), true);
            return;
        }

        Outliner.getInstance().showAABB(connectingFrom, connectingFromBox).colored(AnimationTickHolder.getTicks() % 16 > 8 ? 0x38b764 : 0xa7f070)
            .lineWidth(1 / 16f);

        mc.field_1724.method_7353(
            CreateLang.translate(relocating ? "factory_panel.click_to_relocate" : "factory_panel.click_second_panel").component(), true);

        if (!relocating)
            return;

        validRelocationTarget = null;

        if (!(mc.field_1765 instanceof class_3965 bhr) || bhr.method_17783() == class_240.field_1333)
            return;

        class_243 offsetPos = bhr.method_17784().method_1019(class_243.method_24954(bhr.method_17780().method_62675()).method_1021(1 / 32f));
        class_2338 pos = class_2338.method_49638(offsetPos);
        class_2680 blockState = at.blockEntity.method_11010();
        PanelSlot slot = FactoryPanelBlock.getTargetedSlot(pos, blockState, offsetPos);
        class_2338 diff = pos.method_10059(connectingFrom.pos());
        class_2350 facing = FactoryPanelBlock.connectedDirection(blockState);

        if (facing.method_10166().method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260()) != 0)
            return;
        if (!AllBlocks.FACTORY_GAUGE.method_9558(blockState, world, pos))
            return;
        if (world.method_8320(pos.method_10093(facing.method_10153())).method_27852(AllBlocks.PACKAGER))
            return;

        validRelocationTarget = new FactoryPanelPosition(pos, slot);

        Outliner.getInstance().showAABB("target", getBB(blockState, validRelocationTarget)).colored(0xeeeeee).disableLineNormals().lineWidth(1 / 16f);
    }

    public static boolean onRightClick(class_310 mc) {
        if (connectingFrom == null || connectingFromBox == null)
            return false;
        boolean missed = false;

        class_746 player = mc.field_1724;
        if (relocating) {
            if (player.method_5715())
                validRelocationTarget = null;
            if (validRelocationTarget != null)
                player.field_3944.method_52787(new FactoryPanelConnectionPacket(validRelocationTarget, connectingFrom, true));

            connectingFrom = null;
            connectingFromBox = null;

            if (validRelocationTarget == null)
                player.method_7353(CreateLang.translate("factory_panel.relocation_aborted").component(), true);

            relocating = false;
            validRelocationTarget = null;
            return true;
        }

        if (mc.field_1765 instanceof class_3965 bhr && bhr.method_17783() != class_240.field_1333) {
            class_638 world = mc.field_1687;
            class_2586 blockEntity = world.method_8321(bhr.method_17777());
            FactoryPanelSupportBehaviour behaviour = BlockEntityBehaviour.get(world, bhr.method_17777(), FactoryPanelSupportBehaviour.TYPE);

            // Connecting redstone or display links
            if (behaviour != null) {
                ServerFactoryPanelBehaviour at = ServerFactoryPanelBehaviour.at(world, connectingFrom);
                String checkForIssues = checkForIssues(at, behaviour);
                if (checkForIssues != null) {
                    player.method_7353(CreateLang.translate(checkForIssues).style(class_124.field_1061).component(), true);
                    connectingFrom = null;
                    connectingFromBox = null;
                    AllSoundEvents.DENY.playAt(world, player.method_24515(), 1, 1, false);
                    return true;
                }

                FactoryPanelPosition bestPosition = null;
                double bestDistance = Double.POSITIVE_INFINITY;

                for (PanelSlot slot : PanelSlot.values()) {
                    FactoryPanelPosition panelPosition = new FactoryPanelPosition(blockEntity.method_11016(), slot);
                    FactoryPanelConnection connection = new FactoryPanelConnection(panelPosition, 1);
                    class_243 diff = connection.calculatePathDiff(world.method_8320(connectingFrom.pos()), connectingFrom);
                    if (bestDistance < diff.method_1027())
                        continue;
                    bestDistance = diff.method_1027();
                    bestPosition = panelPosition;
                }

                player.field_3944.method_52787(new FactoryPanelConnectionPacket(bestPosition, connectingFrom, false));

                player.method_7353(
                    CreateLang.translate("factory_panel.link_connected", blockEntity.method_11010().method_26204().method_9518()).style(class_124.field_1060)
                        .component(), true
                );

                connectingFrom = null;
                connectingFromBox = null;
                player.method_73183().method_45446(player.method_24515(), class_3417.field_26940, class_3419.field_15245, 0.5f, 0.5f, false);
                return true;
            }

            if (!(blockEntity instanceof FactoryPanelBlockEntity))
                missed = true;
        }

        if (!player.method_5715() && !missed)
            return false;
        connectingFrom = null;
        connectingFromBox = null;
        player.method_7353(CreateLang.translate("factory_panel.connection_aborted").component(), true);
        return true;
    }

    public static void startRelocating(ServerFactoryPanelBehaviour behaviour) {
        startConnection(behaviour);
        relocating = true;
    }

    public static void startConnection(ServerFactoryPanelBehaviour behaviour) {
        relocating = false;
        connectingFrom = behaviour.getPanelPosition();
        connectingFromBox = getBB(behaviour.blockEntity.method_11010(), connectingFrom);
    }

    public static class_238 getBB(class_2680 blockState, FactoryPanelPosition factoryPanelPosition) {
        class_243 location = FactoryPanelSlotPositioning.getCenterOfSlot(blockState, factoryPanelPosition.slot())
            .method_1019(class_243.method_24954(factoryPanelPosition.pos()));
        class_243 plane = VecHelper.axisAlingedPlaneOf(FactoryPanelBlock.connectedDirection(blockState));
        return new class_238(location, location).method_1009(plane.field_1352 * 3 / 16f, plane.field_1351 * 3 / 16f, plane.field_1350 * 3 / 16f);
    }

}
