package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSetItemMenu;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_768;
import net.minecraft.class_9129;

public class FactoryPanelSetItemScreen extends AbstractSimiContainerScreen<FactoryPanelSetItemMenu> {

    private IconButton confirmButton;
    private ElementWidget renderedItem;
    private List<class_768> extraAreas = Collections.emptyList();

    public FactoryPanelSetItemScreen(FactoryPanelSetItemMenu container, class_1661 inv, class_2561 title) {
        super(container, inv, title);
    }

    public static FactoryPanelSetItemScreen create(
        class_310 mc,
        MenuType<ServerFactoryPanelBehaviour> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        FactoryPanelPosition pos = FactoryPanelPosition.PACKET_CODEC.decode(extraData);
        ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at(mc.field_1687, pos);
        return type.create(FactoryPanelSetItemScreen::new, syncId, inventory, title, behaviour);
    }

    @Override
    protected void method_25426() {
        int bgHeight = AllGuiTextures.FACTORY_GAUGE_SET_ITEM.getHeight();
        int bgWidth = AllGuiTextures.FACTORY_GAUGE_SET_ITEM.getWidth();
        setWindowSize(bgWidth, bgHeight + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.method_25426();
        method_37067();

        confirmButton = new IconButton(field_2776 + bgWidth - 40, field_2800 + bgHeight - 25, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> field_22787.field_1724.method_7346());
        method_37063(confirmButton);

        extraAreas = List.of(new class_768(field_2776 + bgWidth, field_2800 + bgHeight - 30, 40, 20));

        renderedItem = new ElementWidget(field_2776 + 180, field_2800 + 48).showingElement(GuiGameElement.of(AllItems.FACTORY_GAUGE.method_7854())
            .scale(3));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    @Override
    protected void method_2389(class_332 pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        AllGuiTextures.FACTORY_GAUGE_SET_ITEM.render(pGuiGraphics, field_2776 - 5, field_2800);
        renderPlayerInventory(pGuiGraphics, field_2776 + 5, field_2800 + 94);

        class_2561 title = CreateLang.translate("gui.factory_panel.place_item_to_monitor").component();
        pGuiGraphics.method_51439(field_22793, title, field_2776 + field_2792 / 2 - field_22793.method_27525(title) / 2 - 5, field_2800 + 4, 0xFF3D3C48, false);
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

}
