package com.zurrtum.create.client.content.logistics.funnel;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock.Shape;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;

public class FunnelFilterSlotPositioning extends ValueBoxTransform.Sided {

    @Override
    public class_243 getLocalOffset(class_2680 state) {
        class_2350 side = getSide();
        float horizontalAngle = AngleHelper.horizontalAngle(side);
        class_2350 funnelFacing = FunnelBlock.getFunnelFacing(state);
        float stateAngle = AngleHelper.horizontalAngle(funnelFacing);

        if (state.method_26204() instanceof BeltFunnelBlock) {
            switch (state.method_11654(BeltFunnelBlock.SHAPE)) {

                case EXTENDED:
                    return VecHelper.rotateCentered(VecHelper.voxelSpace(8, 15.5f, 13), stateAngle, class_2351.field_11052);
                case PULLING:
                case PUSHING:
                    return VecHelper.rotateCentered(VecHelper.voxelSpace(8, 12.0f, 8.675f), horizontalAngle, class_2351.field_11052);
                default:
                case RETRACTED:
                    return VecHelper.rotateCentered(VecHelper.voxelSpace(8, 13, 7.5f), horizontalAngle, class_2351.field_11052);
            }
        }

        if (!funnelFacing.method_10166().method_10179()) {
            class_243 southLocation = VecHelper.voxelSpace(8, funnelFacing == class_2350.field_11033 ? 14 : 2, 15.5f);
            return VecHelper.rotateCentered(southLocation, horizontalAngle, class_2351.field_11052);
        }

        return VecHelper.rotateCentered(VecHelper.voxelSpace(8, 12.2, 8.55f), horizontalAngle, class_2351.field_11052);
    }

    @Override
    public void rotate(class_2680 state, class_4587 ms) {
        class_2350 facing = FunnelBlock.getFunnelFacing(state);

        if (facing.method_10166().method_10178()) {
            super.rotate(state, ms);
            return;
        }

        boolean isBeltFunnel = state.method_26204() instanceof BeltFunnelBlock;
        if (isBeltFunnel && state.method_11654(BeltFunnelBlock.SHAPE) != Shape.EXTENDED) {
            Shape shape = state.method_11654(BeltFunnelBlock.SHAPE);
            super.rotate(state, ms);
            if (shape == Shape.PULLING || shape == Shape.PUSHING)
                TransformStack.of(ms).rotateXDegrees(-22.5f);
            return;
        }

        if (state.method_26204() instanceof FunnelBlock) {
            super.rotate(state, ms);
            TransformStack.of(ms).rotateXDegrees(-22.5f);
            return;
        }

        float yRot = AngleHelper.horizontalAngle(AbstractFunnelBlock.getFunnelFacing(state)) + (facing == class_2350.field_11033 ? 180 : 0);
        TransformStack.of(ms).rotateYDegrees(yRot).rotateXDegrees(facing == class_2350.field_11033 ? -90 : 90);
    }

    @Override
    protected boolean isSideActive(class_2680 state, class_2350 direction) {
        class_2350 facing = FunnelBlock.getFunnelFacing(state);

        if (facing == null)
            return false;
        if (facing.method_10166().method_10178())
            return direction.method_10166().method_10179();
        if (state.method_26204() instanceof BeltFunnelBlock && state.method_11654(BeltFunnelBlock.SHAPE) == Shape.EXTENDED)
            return direction == class_2350.field_11036;
        return direction == facing;
    }

    @Override
    protected class_243 getSouthLocation() {
        return class_243.field_1353;
    }

}
