package com.zurrtum.create.client.content.logistics.packagePort;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.PackagePortMenu;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.PackagePortConfigurationPacket;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_768;
import net.minecraft.class_9129;

public class PackagePortScreen extends AbstractSimiContainerScreen<PackagePortMenu> {

    private final boolean frogMode;
    private final AllGuiTextures background;

    private class_342 addressBox;
    private IconButton confirmButton;
    private IconButton dontAcceptPackages;
    private IconButton acceptPackages;
    private ElementWidget renderedItem;

    private final class_1799 icon;

    private List<class_768> extraAreas = Collections.emptyList();

    public PackagePortScreen(PackagePortMenu container, class_1661 inv, class_2561 title) {
        super(container, inv, title);
        background = AllGuiTextures.FROGPORT_BG;
        frogMode = container.contentHolder instanceof FrogportBlockEntity;
        icon = new class_1799(container.contentHolder.method_11010().method_26204().method_8389());
    }

    public static PackagePortScreen create(
        class_310 mc,
        MenuType<PackagePortBlockEntity> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        return type.create(PackagePortScreen::new, syncId, inventory, title, getBlockEntity(mc, extraData));
    }

    @Override
    protected void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight() + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.method_25426();
        method_37067();

        Consumer<String> onTextChanged;
        onTextChanged = s -> addressBox.method_46421(nameBoxX(s, addressBox));
        addressBox = new class_342(new NoShadowFontWrapper(field_22793), field_2776 + 23, field_2800 - 11, background.getWidth() - 20, 10, class_2561.method_43473());
        addressBox.method_1858(false);
        addressBox.method_1880(25);
        addressBox.method_1868(0xFF3D3C48);
        addressBox.method_1852(field_2797.contentHolder.addressFilter);
        addressBox.method_25365(false);
        addressBox.method_25402(new class_11909(0, 0, new class_11910(0, 0)), false);
        addressBox.method_1863(onTextChanged);
        addressBox.method_46421(nameBoxX(addressBox.method_1882(), addressBox));
        method_37063(addressBox);

        confirmButton = new IconButton(field_2776 + background.getWidth() - 33, field_2800 + background.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> field_22787.field_1724.method_7346());
        method_37063(confirmButton);

        acceptPackages = new IconButton(field_2776 + 37, field_2800 + background.getHeight() - 24, AllIcons.I_SEND_AND_RECEIVE);
        acceptPackages.withCallback(() -> {
            acceptPackages.green = true;
            dontAcceptPackages.green = false;
        });
        acceptPackages.green = field_2797.contentHolder.acceptsPackages;
        acceptPackages.setToolTip(CreateLang.translateDirect("gui.package_port.send_and_receive"));
        method_37063(acceptPackages);

        dontAcceptPackages = new IconButton(field_2776 + 37 + 18, field_2800 + background.getHeight() - 24, AllIcons.I_SEND_ONLY);
        dontAcceptPackages.withCallback(() -> {
            acceptPackages.green = false;
            dontAcceptPackages.green = true;
        });
        dontAcceptPackages.green = !field_2797.contentHolder.acceptsPackages;
        dontAcceptPackages.setToolTip(CreateLang.translateDirect("gui.package_port.send_only"));
        method_37063(dontAcceptPackages);

        method_37432();

        extraAreas = ImmutableList.of(new class_768(field_2776 + background.getWidth(), field_2800 + background.getHeight() - 50, 70, 60));

        renderedItem = new ElementWidget(field_2776 + background.getWidth() + 6, field_2800 + background.getHeight() - 56).showingElement(GuiGameElement.of(
            icon).scale(4));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    private int nameBoxX(String s, class_342 nameBox) {
        return field_2776 + background.getWidth() / 2 - (Math.min(field_22793.method_1727(s), nameBox.method_25368()) + 10) / 2;
    }

    @Override
    protected void method_37432() {
        acceptPackages.field_22764 = field_2797.contentHolder.target != null;
        dontAcceptPackages.field_22764 = field_2797.contentHolder.target != null;
        super.method_37432();
    }

    @Override
    protected void method_2389(class_332 graphics, float pPartialTick, int pMouseX, int pMouseY) {
        AllGuiTextures header = frogMode ? AllGuiTextures.FROGPORT_HEADER : AllGuiTextures.POSTBOX_HEADER;
        int x = this.field_2776;
        int y = this.field_2800;
        header.render(graphics, x, y - header.getHeight());
        background.render(graphics, x, y);

        String text = addressBox.method_1882();
        if (!addressBox.method_25370()) {
            if (text.isEmpty()) {
                text = icon.method_7964().getString();
                graphics.method_51433(field_22793, text, nameBoxX(text, addressBox), y - 11, 0xFF3D3C48, false);
            }
            AllGuiTextures.FROGPORT_EDIT_NAME.render(graphics, nameBoxX(text, addressBox) + field_22793.method_1727(text) + 5, y - 14);
        }

        int invX = x + 30;
        int invY = y + 8 + field_2779 - AllGuiTextures.PLAYER_INVENTORY.getHeight();
        renderPlayerInventory(graphics, invX, invY);

        if (field_2797.contentHolder.target == null)
            return;

        x += 13;
        y += 58;
        AllGuiTextures.FROGPORT_SLOT.render(graphics, x, y);
        graphics.method_51427(field_2797.contentHolder.target.getIcon(), x + 1, y + 1);

        if (addressBox.method_49606()) {
            graphics.method_51434(
                field_22793, List.of(
                    CreateLang.translate("gui.package_port.catch_packages").color(AbstractSimiWidget.HEADER_RGB).component(),
                    CreateLang.translate("gui.package_port.catch_packages_empty").style(class_124.field_1080).component(),
                    CreateLang.translate("gui.package_port.catch_packages_wildcard").style(class_124.field_1080).component()
                ), pMouseX, pMouseY
            );
        }
    }

    @Override
    public boolean method_25404(class_11908 input) {
        int pKeyCode = input.comp_4795();
        boolean hitEnter = method_25399() instanceof class_342 && (pKeyCode == class_3675.field_31957 || pKeyCode == class_3675.field_31980);

        if (hitEnter && addressBox.method_25370()) {
            addressBox.method_25365(false);
            return true;
        }

        return super.method_25404(input);
    }

    @Override
    public void method_25432() {
        field_22787.field_1724.field_3944.method_52787(new PackagePortConfigurationPacket(
            field_2797.contentHolder.method_11016(),
            addressBox.method_1882(),
            acceptPackages.green
        ));
        super.method_25432();
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

}