package com.zurrtum.create.client.content.logistics.packagePort;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.PackagePortTarget;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.PackagePortPlacementPacket;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_239.class_240;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class PackagePortTargetSelectionHandler {

    public static PackagePortTarget activePackageTarget;
    public static class_243 exactPositionOfTarget;
    public static boolean isPostbox;

    public static void flushSettings(class_746 player, class_2338 pos) {
        if (activePackageTarget == null) {
            CreateLang.translate("gui.package_port.not_targeting_anything").sendStatus(player);
            return;
        }

        if (validateDiff(exactPositionOfTarget, pos) == null) {
            activePackageTarget.relativePos = activePackageTarget.relativePos.method_10059(pos);
            player.field_3944.method_52787(new PackagePortPlacementPacket(activePackageTarget, pos));
        }

        activePackageTarget = null;
        isPostbox = false;
    }

    public static boolean onUse(class_310 mc) {
        class_239 hitResult = mc.field_1765;

        if (hitResult == null || hitResult.method_17783() == class_240.field_1333)
            return false;
        if (!(hitResult instanceof class_3965 bhr))
            return false;

        class_2338 pos = bhr.method_17777();
        if (!(mc.field_1687.method_8321(pos) instanceof StationBlockEntity sbe))
            return false;
        if (sbe.edgePoint == null)
            return false;
        class_1799 mainHandItem = mc.field_1724.method_6047();
        if (!mainHandItem.method_31573(AllItemTags.POSTBOXES))
            return false;

        PackagePortTargetSelectionHandler.exactPositionOfTarget = class_243.method_24953(pos);
        PackagePortTargetSelectionHandler.activePackageTarget = new PackagePortTarget.TrainStationFrogportTarget(pos);
        PackagePortTargetSelectionHandler.isPostbox = true;
        return true;
    }

    public static void tick(class_310 mc) {
        class_746 player = mc.field_1724;
        class_1799 stack = player.method_6047();
        boolean isPostbox = stack.method_31573(AllItemTags.POSTBOXES);
        boolean isWrench = stack.method_31573(AllItemTags.TOOLS_WRENCH);

        if (!isWrench) {
            if (activePackageTarget == null)
                return;
            if (!stack.method_31574(AllItems.PACKAGE_FROGPORT) && !isPostbox)
                return;
        }

        class_239 objectMouseOver = mc.field_1765;
        if (!(objectMouseOver instanceof class_3965 blockRayTraceResult))
            return;

        if (isWrench) {
            if (blockRayTraceResult.method_17783() == class_240.field_1333)
                return;
            class_2338 pos = blockRayTraceResult.method_17777();
            if (!(mc.field_1687.method_8321(pos) instanceof PackagePortBlockEntity ppbe))
                return;
            if (ppbe.target == null)
                return;
            class_243 source = class_243.method_24955(pos);
            class_243 target = ppbe.target.getExactTargetLocation(ppbe, mc.field_1687, pos);
            if (target == class_243.field_1353)
                return;
            Color color = new Color(0x9ede73);
            animateConnection(mc, source, target, color);
            Outliner.getInstance().chaseAABB("ChainPointSelected", new class_238(target, target)).colored(color).lineWidth(1 / 5f).disableLineNormals();
            return;
        }

        class_243 target = exactPositionOfTarget;
        if (blockRayTraceResult.method_17783() == class_240.field_1333) {
            Outliner.getInstance().chaseAABB("ChainPointSelected", new class_238(target, target)).colored(0x9ede73).lineWidth(1 / 5f).disableLineNormals();
            return;
        }

        class_2338 pos = blockRayTraceResult.method_17777();
        if (!mc.field_1687.method_8320(pos).method_45474())
            pos = pos.method_10093(blockRayTraceResult.method_17780());

        String validateDiff = validateDiff(target, pos);
        boolean valid = validateDiff == null;
        Color color = new Color(valid ? 0x9ede73 : 0xff7171);
        class_243 source = class_243.method_24955(pos);

        CreateLang.translate(validateDiff != null ? validateDiff : "package_port.valid").color(color.getRGB()).sendStatus(player);

        Outliner.getInstance().chaseAABB("ChainPointSelected", new class_238(target, target)).colored(color).lineWidth(1 / 5f).disableLineNormals();

        if (!mc.field_1687.method_8320(pos).method_45474())
            return;

        Outliner.getInstance().chaseAABB("TargetedFrogPos", new class_238(pos).method_1002(0, 1, 0).method_35580(0.125, 0, 0.125)).colored(color)
            .lineWidth(1 / 16f).disableLineNormals();

        animateConnection(mc, source, target, color);

    }

    public static void animateConnection(class_310 mc, class_243 source, class_243 target, Color color) {
        class_2390 data = new class_2390(color.getRGB(), 1);
        class_638 world = mc.field_1687;
        double totalFlyingTicks = 10;
        int segments = (((int) totalFlyingTicks) / 3) + 1;
        double tickOffset = totalFlyingTicks / segments;

        for (int i = 0; i < segments; i++) {
            double ticks = ((AnimationTickHolder.getRenderTime() / 3) % tickOffset) + i * tickOffset;
            class_243 vec = source.method_35590(target, ticks / totalFlyingTicks);
            world.method_8406(data, vec.field_1352, vec.field_1351, vec.field_1350, 0, 0, 0);
        }

    }

    public static String validateDiff(class_243 target, class_2338 placedPos) {
        class_243 source = class_243.method_24955(placedPos);
        class_243 diff = target.method_1020(source);
        if (diff.field_1351 < 0 && !isPostbox)
            return "package_port.cannot_reach_down";
        if (diff.method_1033() > AllConfigs.server().logistics.packagePortRange.get())
            return "package_port.too_far";
        return null;
    }

}
