package com.zurrtum.create.client.content.logistics.tableCloth;

import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.tableCloth.ServerTableClothFilteringBehaviour;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class TableClothFilteringBehaviour extends FilteringBehaviour<ServerTableClothFilteringBehaviour> {
    public TableClothFilteringBehaviour(TableClothBlockEntity be) {
        super(be, new TableClothFilterSlot(be));
    }

    @Override
    public float getRenderDistance() {
        return 32;
    }

    @Override
    public class_5250 getLabel() {
        return CreateLang.translateDirect("table_cloth.price_per_order");
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        return new ValueSettingsBoard(
            getLabel(),
            100,
            10,
            CreateLang.translatedOptions("table_cloth", "amount"),
            new ValueSettingsFormatter(this::formatValue)
        );
    }

    @Override
    public class_5250 formatValue(ValueSettings value) {
        return class_2561.method_43470(String.valueOf(Math.max(1, value.value())));
    }

    @Override
    public class_5250 getCountLabelForValueBox() {
        return class_2561.method_43470(isCountVisible() ? String.valueOf(behaviour.count) : "");
    }

    public boolean targetsPriceTag(class_1657 player, class_3965 ray) {
        return behaviour != null && behaviour.mayInteract(player) && getSlotPositioning().testHit(
            blockEntity.method_10997(),
            blockEntity.method_11016(),
            blockEntity.method_11010(),
            ray.method_17784().method_1020(class_243.method_24954(blockEntity.method_11016()))
        );
    }
}
