package com.zurrtum.create.client.content.logistics.tableCloth;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer.DepotOutputItemState;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

import java.util.List;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;

public class TableClothRenderer extends SmartBlockEntityRenderer<TableClothBlockEntity, TableClothRenderer.TableClothRenderState> {
    public TableClothRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public TableClothRenderState createRenderState() {
        return new TableClothRenderState();
    }

    @Override
    public void extractRenderState(
        TableClothBlockEntity be,
        TableClothRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        state.radians = class_3532.field_29847 * (180 - be.facing.method_10144());
        if (be.isShop()) {
            state.layer = class_12249.method_75972();
            state.shop = CachedBuffers.partial(
                be.sideOccluded ? AllPartialModels.TABLE_CLOTH_PRICE_TOP : AllPartialModels.TABLE_CLOTH_PRICE_SIDE,
                state.blockState
            );
        }
        List<class_1799> stacks = be.getItemsForRender();
        int size = stacks.size();
        if (size == 0) {
            return;
        }
        DepotOutputItemState[] items = state.items = new DepotOutputItemState[size];
        class_1937 world = be.method_10997();
        for (int i = 0; i < size; i++) {
            items[i] = DepotOutputItemState.create(itemModelManager, stacks.get(i), world);
        }
        state.itemPosition = class_243.method_24953(state.blockPos);
    }

    @Override
    public void submit(TableClothRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.shop != null) {
            queue.method_73483(matrices, state.layer, state);
        }
        DepotOutputItemState[] items = state.items;
        if (items != null) {
            matrices.method_49278(new Quaternionf().setAngleAxis(state.radians, 0, 1, 0), 0.5f, 0.5f, 0.5f);
            int size = items.length;
            boolean multiple = size > 1;
            for (int i = 0; i < size; i++) {
                matrices.method_22903();
                matrices.method_46416(0.5f, 0.1875f, 0.5f);
                if (multiple) {
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(i * (360f / size) + 45f));
                    matrices.method_46416(0, i % 2 == 0 ? -0.005f : 0, 0.3125f);
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(-i * (360f / size) - 45f));
                }
                DepotOutputItemState item = items[i];
                DepotRenderer.renderItem(
                    queue,
                    matrices,
                    state.lightCoords,
                    item.state(),
                    0,
                    item.upright(),
                    item.box(),
                    item.count(),
                    null,
                    state.itemPosition,
                    cameraState.field_63078,
                    true,
                    (stack, blockItem) -> {
                        if (!blockItem) {
                            stack.rotate(-state.radians + Mth.PI, Direction.UP);
                        }
                    }
                );
                matrices.method_22909();
            }
        }
    }

    public static class TableClothRenderState extends SmartRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer shop;
        public float radians;
        public DepotOutputItemState[] items;
        public class_243 itemPosition;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            shop.rotateCentered(radians, class_2350.field_11036);
            shop.light(lightCoords);
            shop.overlay(class_4608.field_21444);
            shop.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
