package com.zurrtum.create.client.content.processing.burner;

import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock.HeatLevel;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_765;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class BlazeBurnerRenderer implements class_827<BlazeBurnerBlockEntity, BlazeBurnerRenderer.BlazeBurnerRenderState> {
    public BlazeBurnerRenderer(class_5614.class_5615 context) {
    }

    @Override
    public BlazeBurnerRenderState method_74335() {
        return new BlazeBurnerRenderState();
    }

    @Override
    public void extractRenderState(
        BlazeBurnerBlockEntity be,
        BlazeBurnerRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        HeatLevel heatLevel = be.getHeatLevelForRender();
        if (heatLevel == HeatLevel.NONE)
            return;
        class_11954.method_74399(be, state, crumblingOverlay);
        class_1937 level = be.method_10997();
        float animation = be.headAnimation.getValue(tickProgress) * .175f;
        float horizontalAngle = AngleHelper.rad(be.headAngle.getValue(tickProgress));
        boolean canDrawFlame = heatLevel.isAtLeast(HeatLevel.FADING);
        boolean drawGoggles = be.goggles;
        PartialModel drawHat = be.hat ? AllPartialModels.TRAIN_HAT : be.stockKeeper ? AllPartialModels.LOGISTICS_HAT : null;
        int hashCode = be.hashCode();
        state.data = getBlazeBurnerRenderData(
            level,
            state.field_62674,
            heatLevel,
            animation,
            horizontalAngle,
            canDrawFlame,
            drawGoggles,
            drawHat,
            hashCode
        );
    }

    @Override
    public void submit(BlazeBurnerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        state.data.render(matrices, queue);
    }

    public static PartialModel getBlazeModel(HeatLevel heatLevel, boolean blockAbove) {
        if (heatLevel.isAtLeast(HeatLevel.SEETHING)) {
            return blockAbove ? AllPartialModels.BLAZE_SUPER_ACTIVE : AllPartialModels.BLAZE_SUPER;
        } else if (heatLevel.isAtLeast(HeatLevel.FADING)) {
            return blockAbove && heatLevel.isAtLeast(HeatLevel.KINDLED) ? AllPartialModels.BLAZE_ACTIVE : AllPartialModels.BLAZE_IDLE;
        } else {
            return AllPartialModels.BLAZE_INERT;
        }
    }

    public static void tickAnimation(BlazeBurnerBlockEntity be) {
        boolean active = be.getHeatLevelFromBlock().isAtLeast(HeatLevel.FADING) && be.isValidBlockAbove();

        if (!active) {
            float target = 0;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && !player.method_5767()) {
                double x;
                double z;
                if (be.isVirtual()) {
                    x = -4;
                    z = -10;
                } else {
                    x = player.method_23317();
                    z = player.method_23321();
                }
                double dx = x - (be.method_11016().method_10263() + 0.5);
                double dz = z - (be.method_11016().method_10260() + 0.5);
                target = AngleHelper.deg(-class_3532.method_15349(dz, dx)) - 90;
            }
            target = be.headAngle.getValue() + AngleHelper.getShortestAngleDiff(be.headAngle.getValue(), target);
            be.headAngle.chase(target, .25f, Chaser.exp(5));
            be.headAngle.tickChaser();
        } else {
            be.headAngle.chase(
                (AngleHelper.horizontalAngle(be.method_11010().method_28500(BlazeBurnerBlock.field_11177).orElse(class_2350.field_11035)) + 180) % 360,
                .125f,
                Chaser.EXP
            );
            be.headAngle.tickChaser();
        }

        be.headAnimation.chase(active ? 1 : 0, .25f, Chaser.exp(.25f));
        be.headAnimation.tickChaser();
    }

    public static BlazeBurnerRenderData getBlazeBurnerRenderData(
        class_1937 level,
        class_2680 blockState,
        HeatLevel heatLevel,
        float animation,
        float horizontalAngle,
        boolean canDrawFlame,
        boolean drawGoggles,
        @Nullable PartialModel drawHat,
        int hashCode
    ) {
        BlazeBurnerRenderData data = new BlazeBurnerRenderData();
        data.layer = class_12249.method_75965();
        data.horizontalAngle = horizontalAngle;
        boolean blockAbove = animation > 0.125f;
        float time = AnimationTickHolder.getRenderTime(level);
        float renderTick = time / 16f + (hashCode % 13);
        float offsetMult = heatLevel.isAtLeast(HeatLevel.FADING) ? 64 : 16;
        float offset = class_3532.method_15374(renderTick % class_3532.field_29846) / offsetMult;
        float offset1 = class_3532.method_15374((float) ((renderTick + Math.PI) % class_3532.field_29846)) / offsetMult;
        float offset2 = class_3532.method_15374((renderTick + class_3532.field_29845) % class_3532.field_29846) / offsetMult;
        data.headY = offset - (animation * .75f);
        PartialModel blazeModel = getBlazeModel(heatLevel, blockAbove);
        data.blaze = CachedBuffers.partial(blazeModel, blockState);
        if (drawGoggles) {
            PartialModel gogglesModel = blazeModel == AllPartialModels.BLAZE_INERT ? AllPartialModels.BLAZE_GOGGLES_SMALL : AllPartialModels.BLAZE_GOGGLES;
            data.goggles = CachedBuffers.partial(gogglesModel, blockState);
            data.gogglesHeadY = data.headY + 0.5f;
        }
        if (drawHat != null) {
            data.hat = new HatRenderState();
            boolean scale = blazeModel == AllPartialModels.BLAZE_INERT;
            data.hat.scale = scale;
            data.hat.offset = data.headY + (scale ? 0.5f : 0.75f);
            data.hat.layer = class_12249.method_75972();
            data.hat.model = CachedBuffers.partial(drawHat, blockState);
            data.hat.angle = horizontalAngle + class_3532.field_29844;
        }
        if (heatLevel.isAtLeast(HeatLevel.FADING)) {
            PartialModel rodsModel = heatLevel == HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
            PartialModel rodsModel2 = heatLevel == HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
            data.rods = CachedBuffers.partial(rodsModel, blockState);
            data.rodsY = offset1 + animation + .125f;
            data.rods2 = CachedBuffers.partial(rodsModel2, blockState);
            data.rods2Y = offset2 + animation - 3 / 16f;
        }
        if (canDrawFlame && blockAbove) {
            data.flame = new FlameRenderState();
            data.flame.layer = class_12249.method_75972();
            data.flame.model = CachedBuffers.partial(AllPartialModels.BLAZE_BURNER_FLAME, blockState);
            data.flame.angle = horizontalAngle;
            data.flame.spriteShift = heatLevel == HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            class_1058 target = data.flame.spriteShift.getTarget();
            float spriteWidth = target.method_4577() - target.method_4594();
            float spriteHeight = target.method_4575() - target.method_4593();
            float speed = 1 / 32f + 1 / 64f * heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll = vScroll - Math.floor(vScroll);
            vScroll = vScroll * spriteHeight / 2;
            data.flame.vScroll = (float) vScroll;
            double uScroll = speed * time / 2;
            uScroll = uScroll - Math.floor(uScroll);
            uScroll = uScroll * spriteWidth / 2;
            data.flame.uScroll = (float) uScroll;
        }
        return data;
    }

    public static class BlazeBurnerRenderState extends class_11954 {
        public BlazeBurnerRenderData data;
    }

    public static class BlazeBurnerRenderData implements class_11659.class_11660 {
        public class_1921 layer;
        public float headY;
        public float horizontalAngle;
        public SuperByteBuffer blaze;
        public SuperByteBuffer goggles;
        public float gogglesHeadY;
        public HatRenderState hat;
        public SuperByteBuffer rods;
        public float rodsY;
        public SuperByteBuffer rods2;
        public float rods2Y;
        public FlameRenderState flame;

        public void render(class_4587 matrices, class_11659 queue) {
            queue.method_73483(matrices, layer, this);
            if (hat != null) {
                queue.method_73483(matrices, hat.layer, hat);
            }
            if (flame != null) {
                queue.method_73483(matrices, flame.layer, flame);
            }
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            blaze.translate(0, headY, 0);
            blaze.rotateCentered(horizontalAngle, class_2350.field_11036);
            blaze.light(class_765.field_32767);
            blaze.renderInto(matricesEntry, vertexConsumer);
            if (goggles != null) {
                goggles.translate(0, gogglesHeadY, 0);
                goggles.rotateCentered(horizontalAngle, class_2350.field_11036);
                goggles.light(class_765.field_32767);
                goggles.renderInto(matricesEntry, vertexConsumer);
            }
            if (rods != null) {
                rods.translate(0, rodsY, 0);
                rods.light(class_765.field_32767);
                rods.renderInto(matricesEntry, vertexConsumer);
                rods2.translate(0, rods2Y, 0);
                rods2.light(class_765.field_32767);
                rods2.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }

    public static class HatRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public float angle;
        public boolean scale;
        public float offset;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.translate(0, offset, 0);
            if (scale) {
                model.scale(0.75f);
            }
            model.rotateCentered(angle, class_2350.field_11036);
            model.translate(0.5f, 0, 0.5f);
            model.light(class_765.field_32767);
            model.renderInto(matricesEntry, vertexConsumer);
        }
    }

    public static class FlameRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public SpriteShiftEntry spriteShift;
        public float uScroll;
        public float vScroll;
        public float angle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.shiftUVScrolling(spriteShift, uScroll, vScroll);
            model.rotateCentered(angle, class_2350.field_11036);
            model.light(class_765.field_32767);
            model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
