package com.zurrtum.create.client.content.processing.burner;

import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.flywheel.api.instance.InstanceHandle;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;

public class ScrollTransformedInstance extends TransformedInstance {
    public float speedU;
    public float speedV;

    public float offsetU;
    public float offsetV;

    public float diffU;
    public float diffV;

    public float scaleU;
    public float scaleV;

    public ScrollTransformedInstance(InstanceType<? extends TransformedInstance> type, InstanceHandle handle) {
        super(type, handle);
    }

    public ScrollTransformedInstance setSpriteShift(SpriteShiftEntry spriteShift) {
        return setSpriteShift(spriteShift, 0.5f, 0.5f);
    }

    public ScrollTransformedInstance setSpriteShift(SpriteShiftEntry spriteShift, float factorU, float factorV) {
        float spriteWidth = spriteShift.getTarget().method_4577() - spriteShift.getTarget().method_4594();

        float spriteHeight = spriteShift.getTarget().method_4575() - spriteShift.getTarget().method_4593();

        scaleU = spriteWidth * factorU;
        scaleV = spriteHeight * factorV;

        diffU = spriteShift.getTarget().method_4594() - spriteShift.getOriginal().method_4594();
        diffV = spriteShift.getTarget().method_4593() - spriteShift.getOriginal().method_4593();

        return this;
    }

    public ScrollTransformedInstance speed(float speedU, float speedV) {
        this.speedU = speedU;
        this.speedV = speedV;
        return this;
    }

    public ScrollTransformedInstance offset(float offsetU, float offsetV) {
        this.offsetU = offsetU;
        this.offsetV = offsetV;
        return this;
    }
}
