package com.zurrtum.create.client.content.redstone.analogLever;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlock;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class AnalogLeverRenderer implements class_827<AnalogLeverBlockEntity, AnalogLeverRenderer.AnalogLeverRenderState> {
    public AnalogLeverRenderer(class_5614.class_5615 context) {
    }

    @Override
    public AnalogLeverRenderState method_74335() {
        return new AnalogLeverRenderState();
    }

    @Override
    public void extractRenderState(
        AnalogLeverBlockEntity be,
        AnalogLeverRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_12249.method_75965();
        float level = be.clientState.getValue(tickProgress);
        state.angle = (float) ((level / 15) * 90 / 180 * Math.PI);
        state.handle = CachedBuffers.partial(AllPartialModels.ANALOG_LEVER_HANDLE, state.field_62674);
        class_2738 face = state.field_62674.method_11654(AnalogLeverBlock.field_11007);
        float rX = face == class_2738.field_12475 ? 0 : face == class_2738.field_12471 ? 90 : 180;
        float rY = AngleHelper.horizontalAngle(state.field_62674.method_11654(AnalogLeverBlock.field_11177));
        state.xRot = class_3532.field_29847 * rX;
        state.yRot = class_3532.field_29847 * rY;
        state.indicator = CachedBuffers.partial(AllPartialModels.ANALOG_LEVER_INDICATOR, state.field_62674);
        state.color = Color.mixColors(0x2C0300, 0xCD0000, level / 15f);
    }

    @Override
    public void submit(AnalogLeverRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    private SuperByteBuffer transform(SuperByteBuffer buffer, class_2680 leverState) {
        class_2738 face = leverState.method_11654(AnalogLeverBlock.field_11007);
        float rX = face == class_2738.field_12475 ? 0 : face == class_2738.field_12471 ? 90 : 180;
        float rY = AngleHelper.horizontalAngle(leverState.method_11654(AnalogLeverBlock.field_11177));
        buffer.rotateCentered((float) (rY / 180 * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float) (rX / 180 * Math.PI), class_2350.field_11034);
        return buffer;
    }

    public static class AnalogLeverRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public float angle;
        public SuperByteBuffer handle;
        public float xRot;
        public float yRot;
        public SuperByteBuffer indicator;
        public int color;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            handle.rotateCentered(yRot, class_2350.field_11036);
            handle.rotateCentered(xRot, class_2350.field_11034);
            handle.translate(0.5f, 0.0625f, 0.5f).rotate(angle, class_2350.field_11034).translate(-0.5f, -0.0625f, -0.5f);
            handle.light(field_62676).renderInto(matricesEntry, vertexConsumer);
            indicator.rotateCentered(yRot, class_2350.field_11036);
            indicator.rotateCentered(xRot, class_2350.field_11034);
            indicator.light(field_62676).color(color).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
