package com.zurrtum.create.client.content.redstone.displayLink;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.api.behaviour.display.DisplaySourceRender;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.ModularGuiLine;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.ponder.AllCreatePonderTags;
import com.zurrtum.create.client.ponder.foundation.ui.PonderTagScreen;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.infrastructure.packet.c2s.DisplayLinkConfigurationPacket;
import org.joml.Matrix3x2fStack;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_638;

public class DisplayLinkScreen extends AbstractSimiScreen {

    private static final class_1799 FALLBACK = new class_1799(class_1802.field_8077);

    private AllGuiTextures background;
    private DisplayLinkBlockEntity blockEntity;
    private IconButton confirmButton;
    private ElementWidget renderedItem;

    class_2680 sourceState;
    class_2680 targetState;
    List<DisplaySource> sources;
    DisplayTarget target;

    ScrollInput sourceTypeSelector;
    Label sourceTypeLabel;
    ScrollInput targetLineSelector;
    Label targetLineLabel;
    AbstractSimiWidget sourceWidget;
    AbstractSimiWidget targetWidget;

    Couple<ModularGuiLine> configWidgets;

    public DisplayLinkScreen(DisplayLinkBlockEntity be) {
        this.background = AllGuiTextures.DATA_GATHERER;
        this.blockEntity = be;
        sources = Collections.emptyList();
        configWidgets = Couple.create(ModularGuiLine::new);
        target = null;
    }

    @Override
    protected void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight());
        super.method_25426();
        method_37067();

        int x = guiLeft;
        int y = guiTop;


        initGathererOptions();

        confirmButton = new IconButton(x + background.getWidth() - 33, y + background.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(this::method_25419);
        method_37063(confirmButton);

        renderedItem = new ElementWidget(
            x + background.getWidth() - 11,
            y + background.getHeight() - 55
        ).showingElement(GuiGameElement.of(AllItems.DISPLAY_LINK.method_7854()).scale(4).rotate(50, 207, -14).padding(17));
        method_37063(renderedItem);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (sourceState != null && sourceState.method_26204() != field_22787.field_1687.method_8320(blockEntity.getSourcePosition())
            .method_26204() || targetState != null && targetState.method_26204() != field_22787.field_1687.method_8320(blockEntity.getTargetPosition()).method_26204())
            initGathererOptions();
    }

    private void initGathererOptions() {
        class_638 level = field_22787.field_1687;
        sourceState = level.method_8320(blockEntity.getSourcePosition());
        targetState = level.method_8320(blockEntity.getTargetPosition());

        class_1799 asItem;
        int x = guiLeft;
        int y = guiTop;

        class_2248 sourceBlock = sourceState.method_26204();
        class_2248 targetBlock = targetState.method_26204();

        asItem = sourceState.method_65171(level, blockEntity.getSourcePosition(), true);
        class_1799 sourceIcon = asItem == null || asItem.method_7960() ? FALLBACK : asItem;
        asItem = targetState.method_65171(level, blockEntity.getTargetPosition(), true);
        class_1799 targetIcon = asItem == null || asItem.method_7960() ? FALLBACK : asItem;

        sources = DisplaySource.getAll(level, blockEntity.getSourcePosition());
        target = DisplayTarget.get(level, blockEntity.getTargetPosition());

        method_37066(targetLineSelector);
        method_37066(targetLineLabel);
        method_37066(sourceTypeSelector);
        method_37066(sourceTypeLabel);
        method_37066(sourceWidget);
        method_37066(targetWidget);

        configWidgets.forEach(s -> s.forEach(this::method_37066));

        targetLineSelector = null;
        sourceTypeSelector = null;

        if (target != null) {
            DisplayTargetStats stats = target.provideStats(new DisplayLinkContext(level, blockEntity));
            int rows = stats.maxRows();
            int startIndex = Math.min(blockEntity.targetLine, rows);

            targetLineLabel = new Label(x + 65, y + 109, class_5244.field_39003).withShadow();
            targetLineLabel.text = target.getLineOptionText(startIndex);

            if (rows > 1) {
                targetLineSelector = new ScrollInput(x + 61, y + 105, 135, 16).withRange(0, rows)
                    .titled(CreateLang.translateDirect("display_link.display_on")).inverted()
                    .calling(i -> targetLineLabel.text = target.getLineOptionText(i)).setState(startIndex);
                method_37063(targetLineSelector);
            }

            method_37063(targetLineLabel);
        }

        sourceWidget = new ElementWidget(x + 37, y + 26).showingElement(GuiGameElement.of(sourceIcon)).withCallback((mX, mY) -> {
            ScreenOpener.open(new PonderTagScreen(AllCreatePonderTags.DISPLAY_SOURCES));
        });

        sourceWidget.getToolTip().addAll(List.of(
            CreateLang.translateDirect("display_link.reading_from"),
            sourceState.method_26204().method_9518().method_27694(s -> s.method_36139(sources.isEmpty() ? 0xF68989 : 0xF2C16D)),
            CreateLang.translateDirect("display_link.attached_side"),
            CreateLang.translateDirect("display_link.view_compatible").method_27692(class_124.field_1080)
        ));

        method_37063(sourceWidget);

        targetWidget = new ElementWidget(x + 37, y + 105).showingElement(GuiGameElement.of(targetIcon)).withCallback((mX, mY) -> {
            ScreenOpener.open(new PonderTagScreen(AllCreatePonderTags.DISPLAY_TARGETS));
        });

        targetWidget.getToolTip().addAll(List.of(
            CreateLang.translateDirect("display_link.writing_to"),
            targetState.method_26204().method_9518().method_27694(s -> s.method_36139(target == null ? 0xF68989 : 0xF2C16D)),
            CreateLang.translateDirect("display_link.targeted_location"),
            CreateLang.translateDirect("display_link.view_compatible").method_27692(class_124.field_1080)
        ));

        method_37063(targetWidget);

        if (!sources.isEmpty()) {
            int startIndex = Math.max(sources.indexOf(blockEntity.activeSource), 0);

            sourceTypeLabel = new Label(x + 65, y + 30, class_5244.field_39003).withShadow();
            sourceTypeLabel.text = sources.get(startIndex).getName();

            if (sources.size() > 1) {
                List<class_2561> options = sources.stream().map(DisplaySource::getName).toList();
                sourceTypeSelector = new SelectionScrollInput(x + 61, y + 26, 135, 16).forOptions(options).writingTo(sourceTypeLabel)
                    .titled(CreateLang.translateDirect("display_link.information_type")).calling(this::initGathererSourceSubOptions)
                    .setState(startIndex);
                sourceTypeSelector.onChanged();
                method_37063(sourceTypeSelector);
            } else
                initGathererSourceSubOptions(0);

            method_37063(sourceTypeLabel);
        }
    }

    private void initGathererSourceSubOptions(int i) {
        DisplaySource source = sources.get(i);
        source.populateData(new DisplayLinkContext(blockEntity.method_10997(), blockEntity));

        if (targetLineSelector != null)
            targetLineSelector.titled(source instanceof SingleLineDisplaySource ? CreateLang.translateDirect("display_link.display_on") : CreateLang.translateDirect(
                "display_link.display_on_multiline"));

        configWidgets.forEach(s -> {
            s.forEach(this::method_37066);
            s.clear();
        });

        DisplaySourceRender render = source.getAttachRender();
        if (render != null) {
            DisplayLinkContext context = new DisplayLinkContext(field_22787.field_1687, blockEntity);
            configWidgets.forEachWithContext((s, first) -> {
                render.initConfigurationWidgets(source, context, new ModularGuiLineBuilder(field_22793, s, guiLeft + 60, guiTop + (first ? 51 : 72)), first);
            });
        }
        configWidgets.forEach(s -> s.loadValues(blockEntity.getSourceConfig(), this::method_37063, this::method_37060));
    }

    @Override
    public void method_25419() {
        super.method_25419();
        class_2487 sourceData = new class_2487();

        if (!sources.isEmpty()) {
            DisplaySource source = sources.get(sourceTypeSelector == null ? 0 : sourceTypeSelector.getState());
            class_2960 id = CreateRegistries.DISPLAY_SOURCE.method_10221(source);
            if (id != null) {
                sourceData.method_10582("Id", id.toString());
            }
            configWidgets.forEach(s -> s.saveValues(sourceData));
        }

        field_22787.field_1724.field_3944.method_52787(new DisplayLinkConfigurationPacket(
            blockEntity.method_11016(),
            sourceData,
            targetLineSelector == null ? 0 : targetLineSelector.getState()
        ));

        renderedItem.getRenderElement().clear();
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;

        background.render(graphics, x, y);
        class_5250 header = CreateLang.translateDirect("display_link.title");
        graphics.method_51439(field_22793, header, x + background.getWidth() / 2 - field_22793.method_27525(header) / 2, y + 4, 0xFF592424, false);

        if (sources.isEmpty())
            graphics.method_51439(field_22793, CreateLang.translateDirect("display_link.no_source"), x + 65, y + 30, 0xFFD3D3D3, true);
        if (target == null)
            graphics.method_51439(field_22793, CreateLang.translateDirect("display_link.no_target"), x + 65, y + 109, 0xFFD3D3D3, true);

        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        ms.translate(0, guiTop + 46);
        configWidgets.getFirst().renderWidgetBG(guiLeft, graphics);
        ms.translate(0, 21);
        configWidgets.getSecond().renderWidgetBG(guiLeft, graphics);
        ms.popMatrix();
    }

    @Override
    protected void method_37066(class_364 p_169412_) {
        if (p_169412_ != null)
            super.method_37066(p_169412_);
    }
}
