package com.zurrtum.create.client.content.redstone.link.controller;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.infrastructure.model.LinkedControllerModel;
import com.zurrtum.create.content.redstone.link.controller.LecternControllerBlock;
import com.zurrtum.create.content.redstone.link.controller.LecternControllerBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class LecternControllerRenderer implements class_827<LecternControllerBlockEntity, LecternControllerRenderer.LecternControllerRenderState> {
    public LecternControllerRenderer(class_5614.class_5615 context) {
    }

    @Override
    public LecternControllerRenderState method_74335() {
        return new LecternControllerRenderState();
    }

    @Override
    public void extractRenderState(
        LecternControllerBlockEntity be,
        LecternControllerRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        class_310 mc = class_310.method_1551();
        state.model = (LinkedControllerModel) mc.method_1554()
            .method_65746(AllItems.LINKED_CONTROLLER.method_57347().method_58694(class_9334.field_54199));
        state.active = be.hasUser();
        state.renderDepression = be.isUsedBy(mc.field_1724);
        class_2350 facing = state.field_62674.method_11654(LecternControllerBlock.field_16404);
        state.yRot = class_3532.field_29847 * (AngleHelper.horizontalAngle(facing) - 90);
        state.zRot = class_3532.field_29847 * -22;
    }

    @Override
    public void submit(LecternControllerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        matrices.method_46416(0.5f, 1.45f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotation(state.yRot));
        matrices.method_46416(0.28f, 0, 0);
        matrices.method_22907(class_7833.field_40718.rotation(state.zRot));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        state.model.renderInLectern(
            class_811.field_4315,
            matrices,
            queue,
            state.field_62676,
            class_4608.field_21444,
            state.active,
            state.renderDepression
        );
    }

    public static class LecternControllerRenderState extends class_11954 {
        public LinkedControllerModel model;
        public boolean active;
        public boolean renderDepression;
        public float yRot;
        public float zRot;
    }
}
