package com.zurrtum.create.client.content.trains.bogey;

import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class BogeyBlockEntityRenderer<T extends AbstractBogeyBlockEntity> implements class_827<T, BogeyBlockEntityRenderer.BogeyBlockEntityRenderState> {
    public BogeyBlockEntityRenderer(class_5614.class_5615 context) {
    }

    @Override
    public BogeyBlockEntityRenderState method_74335() {
        return new BogeyBlockEntityRenderState();
    }

    @Override
    public void extractRenderState(
        T be,
        BogeyBlockEntityRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        state.field_62674 = be.method_11010();
        if (!(state.field_62674.method_26204() instanceof AbstractBogeyBlock<?> bogey)) {
            return;
        }
        state.field_62673 = be.method_11016();
        state.field_62675 = be.method_11017();
        class_1937 world = be.method_10997();
        state.field_62676 = world != null ? class_761.method_23794(world, state.field_62673) : class_765.field_32767;
        if (state.field_62674.method_11654(AbstractBogeyBlock.AXIS) == class_2350.class_2351.field_11048) {
            state.yRot = class_3532.field_29847 * 90;
        }
        state.bogeyData = be.getBogeyData();
        if (state.bogeyData == null) {
            state.bogeyData = new class_2487();
        }
        state.data = AllBogeyStyleRenders.getRenderData(
            be.getStyle(),
            bogey.getSize(),
            tickProgress,
            state.field_62676,
            be.getVirtualAngle(tickProgress),
            be.getBogeyData(),
            false
        );
    }

    @Override
    public void submit(BogeyBlockEntityRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.data == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(.5f, .5f, .5f);
        if (state.yRot != 0) {
            matrices.method_22907(class_7833.field_40716.rotation(state.yRot));
        }
        state.data.render(matrices, queue);
        matrices.method_22909();
    }

    public static class BogeyBlockEntityRenderState extends class_11954 {
        public float yRot;
        public class_2487 bogeyData;
        public BogeyRenderState data;
    }

    public interface BogeyRenderState {
        void render(class_4587 matrices, class_11659 queue);
    }
}
