package com.zurrtum.create.client.content.trains.bogey;

import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.zurrtum.create.content.trains.bogey.BogeySize;
import com.zurrtum.create.content.trains.bogey.BogeyStyle;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import net.minecraft.class_7833;

public class BogeyBlockEntityVisual extends AbstractBlockEntityVisual<AbstractBogeyBlockEntity> implements SimpleDynamicVisual {
    private final class_4587 poseStack = new class_4587();

    @Nullable
    private final BogeySize bogeySize;
    private BogeyStyle lastStyle;
    @Nullable
    private BogeyVisual bogey;

    public BogeyBlockEntityVisual(VisualizationContext ctx, AbstractBogeyBlockEntity blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);

        lastStyle = blockEntity.getStyle();

        if (!(blockState.method_26204() instanceof AbstractBogeyBlock<?> block)) {
            bogeySize = null;
            return;
        }

        bogeySize = block.getSize();

        class_2338 visualPos = getVisualPosition();
        poseStack.method_46416(visualPos.method_10263(), visualPos.method_10264(), visualPos.method_10260());
        poseStack.method_46416(.5f, .5f, .5f);
        if (blockState.method_11654(AbstractBogeyBlock.AXIS) == class_2350.class_2351.field_11048)
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(90));
        poseStack.method_22904(0, -1.5 - 1 / 128f, 0);

        bogey = AllBogeyStyleRenders.createVisual(lastStyle, bogeySize, visualizationContext, partialTick, false);

        updateBogey(partialTick);
    }

    @Override
    public void beginFrame(Context context) {
        if (bogeySize == null) {
            return;
        }

        BogeyStyle style = blockEntity.getStyle();
        if (style != lastStyle) {
            if (bogey != null) {
                bogey.delete();
                bogey = null;
            }
            lastStyle = style;
            bogey = AllBogeyStyleRenders.createVisual(lastStyle, bogeySize, visualizationContext, context.partialTick(), false);
            updateLight(context.partialTick());
        }

        updateBogey(context.partialTick());
    }

    private void updateBogey(float partialTick) {
        if (bogey == null) {
            return;
        }

        class_2487 bogeyData = blockEntity.getBogeyData();
        float angle = blockEntity.getVirtualAngle(partialTick);
        bogey.update(bogeyData, angle, poseStack);
    }

    @Override
    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        if (bogey != null) {
            bogey.collectCrumblingInstances(consumer);
        }
    }

    @Override
    public void updateLight(float partialTick) {
        if (bogey != null) {
            bogey.updateLight(computePackedLight());
        }
    }

    @Override
    protected void _delete() {
        if (bogey != null) {
            bogey.delete();
        }
    }
}
