package com.zurrtum.create.client.content.trains.track;

import com.google.common.base.Objects;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.trains.GlobalRailwayManagerClient;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline.BezierPointSelection;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour.RenderedTrackOverlayType;
import com.zurrtum.create.content.trains.track.TrackTargetingBlockItem;
import com.zurrtum.create.content.trains.track.TrackTargetingBlockItem.OverlapResult;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_239;
import net.minecraft.class_239.class_240;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public class TrackTargetingClient {

    static class_2338 lastHovered;
    static boolean lastDirection;
    static EdgePointType<?> lastType;
    static BezierTrackPointLocation lastHoveredBezierSegment;

    static OverlapResult lastResult;
    static TrackGraphLocation lastLocation;

    public static void clientTick(class_310 mc) {
        class_746 player = mc.field_1724;
        class_243 lookAngle = player.method_5720();

        class_2338 hovered = null;
        boolean direction = false;
        EdgePointType<?> type = null;
        BezierTrackPointLocation hoveredBezier = null;

        class_1799 stack = player.method_6047();
        if (stack.method_7909() instanceof TrackTargetingBlockItem ttbi)
            type = ttbi.getType(stack);

        if (type == EdgePointType.SIGNAL)
            GlobalRailwayManagerClient.tickSignalOverlay(mc);

        boolean alreadySelected = stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);

        if (type != null) {
            BezierPointSelection bezierSelection = TrackBlockOutline.result;

            if (alreadySelected) {
                hovered = stack.method_58694(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
                direction = stack.method_58695(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, false);
                if (stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER)) {
                    hoveredBezier = stack.method_58694(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
                }

            } else if (bezierSelection != null) {
                hovered = bezierSelection.blockEntity().method_11016();
                hoveredBezier = bezierSelection.loc();
                direction = lookAngle.method_1026(bezierSelection.direction()) < 0;

            } else {
                class_239 hitResult = mc.field_1765;
                if (hitResult != null && hitResult.method_17783() == class_240.field_1332) {
                    class_3965 blockHitResult = (class_3965) hitResult;
                    class_2338 pos = blockHitResult.method_17777();
                    class_2680 blockState = mc.field_1687.method_8320(pos);
                    if (blockState.method_26204() instanceof ITrackBlock track) {
                        direction = track.getNearestTrackAxis(mc.field_1687, pos, blockState, lookAngle).getSecond() == class_2352.field_11056;
                        hovered = pos;
                    }
                }
            }
        }

        if (hovered == null) {
            lastHovered = null;
            lastResult = null;
            lastLocation = null;
            lastHoveredBezierSegment = null;
            return;
        }

        if (Objects.equal(hovered, lastHovered) && Objects.equal(
            hoveredBezier,
            lastHoveredBezierSegment
        ) && direction == lastDirection && type == lastType)
            return;

        lastType = type;
        lastHovered = hovered;
        lastDirection = direction;
        lastHoveredBezierSegment = hoveredBezier;

        TrackTargetingBlockItem.withGraphLocation(
            mc.field_1687, hovered, direction, hoveredBezier, type, (result, location) -> {
                lastResult = result;
                lastLocation = location;
            }
        );
    }

    public static void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
        if (lastLocation == null || lastResult.feedback != null)
            return;

        class_2338 pos = lastHovered;
        class_2352 direction = lastDirection ? class_2352.field_11056 : class_2352.field_11060;

        RenderedTrackOverlayType type = lastType == EdgePointType.SIGNAL ? RenderedTrackOverlayType.SIGNAL : lastType == EdgePointType.OBSERVER ? RenderedTrackOverlayType.OBSERVER : RenderedTrackOverlayType.STATION;

        class_2680 state = mc.field_1687.method_8320(pos);
        if (!(state.method_26204() instanceof ITrackBlock track))
            return;
        TrackBlockRenderer renderer = AllTrackRenders.get(track);
        if (renderer != null) {
            renderer.getRenderState(
                mc.field_1687,
                new class_243(pos.method_10263() - camera.method_10216(), pos.method_10264() - camera.method_10214(), pos.method_10260() - camera.method_10215()),
                state,
                pos,
                direction,
                lastHoveredBezierSegment,
                type,
                1 + 1 / 16f
            ).render(ms, buffer);
        }
    }

}
