package com.zurrtum.create.client.flywheel.api.registry;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

import java.util.Collection;
import java.util.Set;
import net.minecraft.class_2960;

@ApiStatus.NonExtendable
public interface IdRegistry<T> extends Iterable<T> {
    void register(class_2960 id, T object);

    <S extends T> S registerAndGet(class_2960 id, S object);

    @Nullable T get(class_2960 id);

    @Nullable class_2960 getId(T object);

    T getOrThrow(class_2960 id);

    class_2960 getIdOrThrow(T object);

    @UnmodifiableView
    Set<class_2960> getAllIds();

    @UnmodifiableView
    Collection<T> getAll();

    boolean isFrozen();
}
