package com.zurrtum.create.client.flywheel.impl.visualization.storage;

import com.zurrtum.create.client.flywheel.api.visual.BlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public class BlockEntityStorage extends Storage<class_2586> {
    private final Long2ObjectMap<BlockEntityVisual<?>> posLookup = new Long2ObjectOpenHashMap<>();

    @Nullable
    public BlockEntityVisual<?> visualAtPos(long pos) {
        return posLookup.get(pos);
    }

    @Override
    public boolean willAccept(class_2586 blockEntity) {
        if (blockEntity.method_11015()) {
            return false;
        }

        if (!VisualizationHelper.canVisualize(blockEntity)) {
            return false;
        }

        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            return false;
        }

        if (level.method_22347(blockEntity.method_11016())) {
            return false;
        }

        class_2338 pos = blockEntity.method_11016();
        class_1922 existingChunk = level.method_22338(pos.method_10263() >> 4, pos.method_10260() >> 4);
        return existingChunk != null;
    }

    @Override
    @Nullable
    protected BlockEntityVisual<?> createRaw(VisualizationContext visualizationContext, class_2586 obj, float partialTick) {
        var visualizer = VisualizationHelper.getVisualizer(obj);
        if (visualizer == null) {
            return null;
        }

        var visual = visualizer.createVisual(visualizationContext, obj, partialTick);

        class_2338 blockPos = obj.method_11016();
        posLookup.put(blockPos.method_10063(), visual);

        return visual;
    }

    @Override
    public void remove(class_2586 obj) {
        posLookup.remove(obj.method_11016().method_10063());
        super.remove(obj);
    }

    @Override
    public void recreateAll(VisualizationContext visualizationContext, float partialTick) {
        posLookup.clear();
        super.recreateAll(visualizationContext, partialTick);
    }

    @Override
    public void invalidate() {
        posLookup.clear();
        super.invalidate();
    }
}
