package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.vertex.NoOverlayVertexView;
import com.zurrtum.create.client.flywheel.lib.vertex.VertexView;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

import java.nio.ByteBuffer;
import net.minecraft.class_9801;

public final class MeshHelper {
    private MeshHelper() {
    }

    public static SimpleQuadMesh blockVerticesToMesh(class_9801 data, @Nullable String meshDescriptor) {
        class_9801.class_4574 drawState = data.method_60822();
        int vertexCount = drawState.comp_750();
        long srcStride = drawState.comp_749().getVertexSize();

        VertexView vertexView = new NoOverlayVertexView();
        long dstStride = vertexView.stride();

        ByteBuffer src = data.method_60818();
        MemoryBlock dst = MemoryBlock.mallocTracked((long) vertexCount * dstStride);
        long srcPtr = MemoryUtil.memAddress(src);
        long dstPtr = dst.ptr();
        // The first 31 bytes of each vertex in a block vertex buffer are guaranteed to contain the same data in the
        // same order regardless of whether the format is extended by mods like Iris or OptiFine. Copy these bytes and
        // ignore the rest.
        long bytesToCopy = Math.min(dstStride, 31);

        for (int i = 0; i < vertexCount; i++) {
            // It is safe to copy bytes directly since the NoOverlayVertexView uses the same memory layout as the first
            // 31 bytes of the block vertex format, vanilla or otherwise.
            MemoryUtil.memCopy(srcPtr + srcStride * i, dstPtr + dstStride * i, bytesToCopy);
        }

        vertexView.ptr(dstPtr);
        vertexView.vertexCount(vertexCount);
        vertexView.nativeMemoryOwner(dst);

        return new SimpleQuadMesh(vertexView, meshDescriptor);
    }
}
