package com.zurrtum.create.client.flywheel.lib.model.baked;

import java.util.*;
import net.minecraft.class_1088;
import net.minecraft.class_11661;
import net.minecraft.class_11788;
import net.minecraft.class_155;
import net.minecraft.class_1921;
import net.minecraft.class_3879;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class ModelCommandRendererHelper {
    public static void render(
        class_4587 matrices,
        class_11788 queue,
        class_4597 vertexConsumers,
        class_4597 outlineVertexConsumers,
        class_4597 crumblingOverlayVertexConsumers
    ) {
        net.minecraft.class_11683.class_12048 commands = queue.method_74771();
        renderAll(matrices, vertexConsumers, outlineVertexConsumers, commands.field_62982, crumblingOverlayVertexConsumers);
        commands.field_62983.sort(Comparator.comparingDouble(modelCommand -> -modelCommand.comp_4618().lengthSquared()));
        renderAllBlended(matrices, vertexConsumers, outlineVertexConsumers, commands.field_62983, crumblingOverlayVertexConsumers);
    }

    private static void renderAllBlended(
        class_4587 matrices,
        class_4597 vertexConsumers,
        class_4597 outlineVertexConsumers,
        List<class_11661.class_11744<?>> blendedModelCommands,
        class_4597 crumblingOverlayVertexConsumers
    ) {
        for (class_11661.class_11744<?> blendedModelCommand : blendedModelCommands) {
            render(
                matrices,
                blendedModelCommand.comp_4615(),
                blendedModelCommand.comp_4616(),
                vertexConsumers.method_73477(blendedModelCommand.comp_4616()),
                outlineVertexConsumers,
                crumblingOverlayVertexConsumers
            );
        }
    }

    private static void renderAll(
        class_4587 matrices,
        class_4597 vertexConsumers,
        class_4597 outlineVertexConsumers,
        Map<class_1921, List<class_11661.class_11670<?>>> modelCommands,
        class_4597 crumblingOverlayVertexConsumers
    ) {
        Iterable<Map.Entry<class_1921, List<class_11661.class_11670<?>>>> iterable;
        if (class_155.field_61885) {
            List<Map.Entry<class_1921, List<class_11661.class_11670<?>>>> list = new ArrayList<>(modelCommands.entrySet());
            Collections.shuffle(list);
            iterable = list;
        } else {
            iterable = modelCommands.entrySet();
        }

        for (Map.Entry<class_1921, List<class_11661.class_11670<?>>> entry : iterable) {
            class_4588 vertexConsumer = vertexConsumers.method_73477(entry.getKey());

            for (class_11661.class_11670<?> modelCommand : entry.getValue()) {
                render(matrices, modelCommand, entry.getKey(), vertexConsumer, outlineVertexConsumers, crumblingOverlayVertexConsumers);
            }
        }
    }

    private static <S> void render(
        class_4587 matrices,
        class_11661.class_11670<S> model,
        class_1921 renderLayer,
        class_4588 vertexConsumer,
        class_4597 outlineVertexConsumers,
        class_4597 crumblingOverlayVertexConsumers
    ) {
        matrices.method_22903();
        matrices.method_23760().method_66521(model.comp_4504());
        class_3879<? super S> model2 = model.comp_4505();
        class_4588 vertexConsumer2 = model.comp_4510() == null ? vertexConsumer : model.comp_4510().method_24108(vertexConsumer);
        model2.method_2819(model.comp_4506());
        model2.method_62100(matrices, vertexConsumer2, model.comp_4507(), model.comp_4508(), model.comp_4509());
        if (model.comp_4511() != 0 && (renderLayer.method_23289().isPresent() || renderLayer.method_24295())) {
            class_4588 vertexConsumer3 = CustomCommandRendererHelper.getOutlineBuffer(outlineVertexConsumers, renderLayer, model.comp_4511());
            if (vertexConsumer3 != null) {
                if (model.comp_4510() != null) {
                    vertexConsumer3 = model.comp_4510().method_24108(vertexConsumer3);
                }
                model2.method_62100(matrices, vertexConsumer3, model.comp_4507(), model.comp_4508(), model.comp_4509());
            }
        }

        if (model.comp_4651() != null && renderLayer.method_23037()) {
            class_4588 vertexConsumer3 = new class_4583(
                crumblingOverlayVertexConsumers.method_73477(class_1088.field_21772.get(model.comp_4651().comp_4656())),
                model.comp_4651().comp_4657(),
                1.0F
            );
            model2.method_62100(
                matrices,
                model.comp_4510() == null ? vertexConsumer3 : model.comp_4510().method_24108(vertexConsumer3),
                model.comp_4507(),
                model.comp_4508(),
                model.comp_4509()
            );
        }

        matrices.method_22909();
    }
}
