package com.zurrtum.create.client.foundation.block.connected;

import com.zurrtum.create.foundation.block.AppearanceControlBlock;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConnectedTextureBehaviour {

    @Nullable
    public CTSpriteShiftEntry getShift(class_2680 state, class_5819 rand, class_2350 direction, @NotNull class_1058 sprite) {
        return getShift(state, direction, sprite);
    }

    @Nullable
    public abstract CTSpriteShiftEntry getShift(class_2680 state, class_2350 direction, @NotNull class_1058 sprite);

    // TODO: allow more than one data type per state/face?
    @Nullable
    public abstract CTType getDataType(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction);

    public boolean buildContextForOccludedDirections() {
        return false;
    }

    protected boolean isBeingBlocked(class_2680 state, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        class_2338 blockingPos = otherPos.method_10093(face);
        class_2680 blockState = reader.method_8320(pos);
        class_2680 blockingState = reader.method_8320(blockingPos);

        if (!class_2248.method_9501(blockingState.method_26218(reader, blockingPos), face.method_10153()))
            return false;
        if (face.method_10166().method_10173(pos.method_10263(), pos.method_10264(), pos.method_10260()) != face.method_10166().method_10173(otherPos.method_10263(), otherPos.method_10264(), otherPos.method_10260()))
            return false;

        return connectsTo(
            state,
            getCTBlockState(reader, blockState, face.method_10153(), pos.method_10093(face), blockingPos),
            reader,
            pos,
            blockingPos,
            face
        );
    }

    public boolean connectsTo(
        class_2680 state,
        class_2680 other,
        class_1920 reader,
        class_2338 pos,
        class_2338 otherPos,
        class_2350 face,
        class_2350 primaryOffset,
        class_2350 secondaryOffset
    ) {
        return connectsTo(state, other, reader, pos, otherPos, face);
    }

    public boolean connectsTo(class_2680 state, class_2680 other, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        return !isBeingBlocked(state, reader, pos, otherPos, face) && state.method_26204() == other.method_26204();
    }

    private boolean testConnection(
        class_1920 reader,
        class_2338 currentPos,
        class_2680 connectiveCurrentState,
        class_2350 textureSide,
        final class_2350 horizontal,
        final class_2350 vertical,
        int sh,
        int sv
    ) {
        class_2680 trueCurrentState = reader.method_8320(currentPos);
        class_2338 targetPos = currentPos.method_10079(horizontal, sh).method_10079(vertical, sv);
        class_2680 connectiveTargetState = getCTBlockState(reader, trueCurrentState, textureSide, currentPos, targetPos);
        return connectsTo(
            connectiveCurrentState,
            connectiveTargetState,
            reader,
            currentPos,
            targetPos,
            textureSide,
            sh == 0 ? null : sh == -1 ? horizontal.method_10153() : horizontal,
            sv == 0 ? null : sv == -1 ? vertical.method_10153() : vertical
        );
    }

    public class_2680 getCTBlockState(class_1920 reader, class_2680 reference, class_2350 face, class_2338 fromPos, class_2338 toPos) {
        class_2680 blockState = reader.method_8320(toPos);
        if (blockState.method_26204() instanceof AppearanceControlBlock block) {
            return block.getAppearance(blockState, reader, toPos, face, reference, fromPos);
        }
        return blockState;
    }

    protected boolean reverseUVs(class_2680 state, class_2350 face) {
        return false;
    }

    protected boolean reverseUVsHorizontally(class_2680 state, class_2350 face) {
        return reverseUVs(state, face);
    }

    protected boolean reverseUVsVertically(class_2680 state, class_2350 face) {
        return reverseUVs(state, face);
    }

    protected class_2350 getUpDirection(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face) {
        class_2351 axis = face.method_10166();
        return axis.method_10179() ? class_2350.field_11036 : class_2350.field_11043;
    }

    protected class_2350 getRightDirection(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face) {
        class_2351 axis = face.method_10166();
        return axis == class_2351.field_11048 ? class_2350.field_11035 : class_2350.field_11039;
    }

    public CTContext buildContext(class_1920 reader, class_2338 pos, class_2680 state, class_2350 face, ContextRequirement requirement) {
        boolean positive = face.method_10171() == class_2352.field_11056;
        class_2350 h = getRightDirection(reader, pos, state, face);
        class_2350 v = getUpDirection(reader, pos, state, face);
        h = positive ? h.method_10153() : h;
        if (face == class_2350.field_11033) {
            v = v.method_10153();
            h = h.method_10153();
        }

        final class_2350 horizontal = h;
        final class_2350 vertical = v;

        boolean flipH = reverseUVsHorizontally(state, face);
        boolean flipV = reverseUVsVertically(state, face);
        int sh = flipH ? -1 : 1;
        int sv = flipV ? -1 : 1;

        CTContext context = new CTContext();

        if (requirement.up) {
            context.up = testConnection(reader, pos, state, face, horizontal, vertical, 0, sv);
        }
        if (requirement.down) {
            context.down = testConnection(reader, pos, state, face, horizontal, vertical, 0, -sv);
        }
        if (requirement.left) {
            context.left = testConnection(reader, pos, state, face, horizontal, vertical, -sh, 0);
        }
        if (requirement.right) {
            context.right = testConnection(reader, pos, state, face, horizontal, vertical, sh, 0);
        }

        if (requirement.topLeft) {
            context.topLeft = context.up && context.left && testConnection(reader, pos, state, face, horizontal, vertical, -sh, sv);
        }
        if (requirement.topRight) {
            context.topRight = context.up && context.right && testConnection(reader, pos, state, face, horizontal, vertical, sh, sv);
        }
        if (requirement.bottomLeft) {
            context.bottomLeft = context.down && context.left && testConnection(reader, pos, state, face, horizontal, vertical, -sh, -sv);
        }
        if (requirement.bottomRight) {
            context.bottomRight = context.down && context.right && testConnection(reader, pos, state, face, horizontal, vertical, sh, -sv);
        }

        return context;
    }

    public static class CTContext {
        public static final CTContext EMPTY = new CTContext();

        public boolean up, down, left, right;
        public boolean topLeft, topRight, bottomLeft, bottomRight;
    }

    public static class ContextRequirement {
        public final boolean up, down, left, right;
        public final boolean topLeft, topRight, bottomLeft, bottomRight;

        public ContextRequirement(
            boolean up,
            boolean down,
            boolean left,
            boolean right,
            boolean topLeft,
            boolean topRight,
            boolean bottomLeft,
            boolean bottomRight
        ) {
            this.up = up;
            this.down = down;
            this.left = left;
            this.right = right;
            this.topLeft = topLeft;
            this.topRight = topRight;
            this.bottomLeft = bottomLeft;
            this.bottomRight = bottomRight;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private boolean up, down, left, right;
            private boolean topLeft, topRight, bottomLeft, bottomRight;

            public Builder up() {
                up = true;
                return this;
            }

            public Builder down() {
                down = true;
                return this;
            }

            public Builder left() {
                left = true;
                return this;
            }

            public Builder right() {
                right = true;
                return this;
            }

            public Builder topLeft() {
                topLeft = true;
                return this;
            }

            public Builder topRight() {
                topRight = true;
                return this;
            }

            public Builder bottomLeft() {
                bottomLeft = true;
                return this;
            }

            public Builder bottomRight() {
                bottomRight = true;
                return this;
            }

            public Builder horizontal() {
                left();
                right();
                return this;
            }

            public Builder vertical() {
                up();
                down();
                return this;
            }

            public Builder axisAligned() {
                horizontal();
                vertical();
                return this;
            }

            public Builder corners() {
                topLeft();
                topRight();
                bottomLeft();
                bottomRight();
                return this;
            }

            public Builder all() {
                axisAligned();
                corners();
                return this;
            }

            public ContextRequirement build() {
                return new ContextRequirement(up, down, left, right, topLeft, topRight, bottomLeft, bottomRight);
            }
        }
    }

    public static abstract class Base extends ConnectedTextureBehaviour {
        @Override
        @Nullable
        public abstract CTSpriteShiftEntry getShift(class_2680 state, class_2350 direction, @Nullable class_1058 sprite);

        @Override
        @Nullable
        public CTType getDataType(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
            CTSpriteShiftEntry shift = getShift(state, direction, null);
            if (shift == null) {
                return null;
            }
            return shift.getType();
        }
    }

}
