package com.zurrtum.create.client.foundation.blockEntity.behaviour.animation;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class CuckooClockAnimationBehaviour extends AnimationBehaviour<CuckooClockBlockEntity> {
    public LerpedFloat hourHand = LerpedFloat.angular();
    public LerpedFloat minuteHand = LerpedFloat.angular();

    public CuckooClockAnimationBehaviour(CuckooClockBlockEntity be) {
        super(be);
    }

    @Override
    public void tickAnimation() {
        if (blockEntity.getSpeed() == 0)
            return;

        class_1937 world = blockEntity.method_10997();
        int dayTime = (int) (world.method_8532() % 24000);
        int hours = (dayTime / 1000 + 6) % 24;
        int minutes = (dayTime % 1000) * 60 / 1000;
        moveHands(hours, minutes);

        CuckooClockBlockEntity.Animation animationType = blockEntity.animationType;
        if (animationType == CuckooClockBlockEntity.Animation.NONE) {
            if (AnimationTickHolder.getTicks() % 32 == 0)
                playSound(class_3417.field_15204.comp_349(), 1 / 16f, 2f);
            else if (AnimationTickHolder.getTicks() % 16 == 0)
                playSound(class_3417.field_15204.comp_349(), 1 / 16f, 1.5f);
        } else {
            boolean isSurprise = animationType == CuckooClockBlockEntity.Animation.SURPRISE;
            float value = blockEntity.getAndIncrementProgress();
            if (value > 100)
                animationType = null;

            // sounds

            if (value == 1)
                playSound(class_3417.field_14725.comp_349(), 2, .5f);
            if (value == 21)
                playSound(class_3417.field_14725.comp_349(), 2, 0.793701f);

            if (value > 30 && isSurprise) {
                class_243 pos = VecHelper.offsetRandomly(VecHelper.getCenterOf(blockEntity.method_11016()), world.field_9229, .5f);
                world.method_8406(class_2398.field_11237, pos.field_1352, pos.field_1351, pos.field_1350, 0, 0, 0);
            }
            if (value == 40 && isSurprise)
                playSound(class_3417.field_15079, 1f, 1f);

            int step = isSurprise ? 3 : 15;
            for (int phase = 30; phase <= 60; phase += step) {
                if (value == phase - step / 3)
                    playSound(class_3417.field_14982, 1 / 16f, 2f);
                if (value == phase) {
                    if (animationType == CuckooClockBlockEntity.Animation.PIG)
                        playSound(class_3417.field_14615, 1 / 4f, 1f);
                    else
                        playSound(class_3417.field_15192, 1 / 4f, 3f);
                }
                if (value == phase + step / 3)
                    playSound(class_3417.field_14823, 1 / 16f, 2f);

            }

        }
    }

    private void moveHands(int hours, int minutes) {
        float hourTarget = (float) (360 / 12 * (hours % 12));
        float minuteTarget = (float) (360 / 60 * minutes);

        hourHand.chase(hourTarget, .2f, LerpedFloat.Chaser.EXP);
        minuteHand.chase(minuteTarget, .2f, LerpedFloat.Chaser.EXP);

        hourHand.tickChaser();
        minuteHand.tickChaser();
    }

    private void playSound(class_3414 sound, float volume, float pitch) {
        class_243 vec = VecHelper.getCenterOf(blockEntity.method_11016());
        blockEntity.method_10997().method_8486(vec.field_1352, vec.field_1351, vec.field_1350, sound, class_3419.field_15245, volume, pitch, false);
    }
}
