package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.contraptions.DirectionalExtenderScrollOptionSlot;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter.ScrollOptionSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.contraptions.bearing.BearingBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;

import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2561;
import net.minecraft.class_3965;

public abstract class ScrollOptionBehaviour<T extends Enum<T>> extends ScrollValueBehaviour<SmartBlockEntity, ServerScrollOptionBehaviour<T>> {
    private final INamedIconOptions[] icons;
    private final Function<T, INamedIconOptions> iconGetter;

    public <E extends Enum<E> & INamedIconOptions> ScrollOptionBehaviour(
        Class<E> enum_,
        Function<T, INamedIconOptions> getter,
        class_2561 label,
        SmartBlockEntity be,
        ValueBoxTransform slot
    ) {
        super(label, be, slot);
        icons = enum_.getEnumConstants();
        iconGetter = getter;
    }

    public INamedIconOptions getIconForSelected() {
        return iconGetter.apply(behaviour.get());
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        return new ValueSettingsBoard(
            label,
            behaviour.getMax(),
            1,
            ImmutableList.of(class_2561.method_43470("Select")),
            new ScrollOptionSettingsFormatter(icons)
        );
    }

    public static ValueBoxTransform getMovementModeSlot() {
        return new DirectionalExtenderScrollOptionSlot((state, d) -> {
            class_2351 axis = d.method_10166();
            class_2351 bearingAxis = state.method_11654(BearingBlock.FACING).method_10166();
            return bearingAxis != axis;
        });
    }
}
