package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.logistics.depot.EjectorSlot;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerBulkScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class ScrollValueBehaviour<B extends SmartBlockEntity, T extends ServerScrollValueBehaviour> extends BlockEntityBehaviour<B> implements ValueSettingsBehaviour {
    public static final BehaviourType<ScrollValueBehaviour<?, ?>> TYPE = new BehaviourType<>();
    protected T behaviour;
    ValueBoxTransform slotPositioning;

    public class_2561 label;
    protected boolean needsWrench;
    protected Function<Integer, String> formatter = i -> Integer.toString(i);
    protected Supplier<Boolean> isActive = () -> true;

    @SuppressWarnings("unchecked")
    public ScrollValueBehaviour(class_2561 label, B be, ValueBoxTransform slotPositioning) {
        super(be);
        this.label = label;
        this.slotPositioning = slotPositioning;
        behaviour = (T) blockEntity.getBehaviour(ServerScrollValueBehaviour.TYPE);
    }

    @Nullable
    public List<? extends SmartBlockEntity> getBulk() {
        if (behaviour instanceof ServerBulkScrollValueBehaviour bulkBehaviour) {
            return bulkBehaviour.getBulk();
        }
        return null;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void initialize() {
        if (behaviour == null) {
            behaviour = (T) blockEntity.getBehaviour(ServerScrollValueBehaviour.TYPE);
        }
    }

    @Override
    public void tick() {
    }

    public static BlockEntityBehaviour<EjectorBlockEntity> ejector(EjectorBlockEntity blockEntity) {
        return new ScrollValueBehaviour<>(
            CreateLang.translateDirect("weighted_ejector.stack_size"),
            blockEntity,
            new EjectorSlot(blockEntity)
        ).withFormatter(i -> i == 0 ? "*" : String.valueOf(i));
    }

    public ScrollValueBehaviour<B, T> withFormatter(Function<Integer, String> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollValueBehaviour<B, T> onlyActiveWhen(Supplier<Boolean> condition) {
        isActive = condition;
        return this;
    }

    public String formatValue() {
        return formatter.apply(behaviour.getValue());
    }

    @Override
    public boolean isActive() {
        return isActive.get();
    }

    @Override
    public boolean testHit(class_243 hit) {
        class_2680 state = behaviour.blockEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954(behaviour.blockEntity.method_11016()));
        return slotPositioning.testHit(behaviour.getLevel(), behaviour.getPos(), state, localHit);
    }

    public void setLabel(class_2561 label) {
        this.label = label;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static class StepContext {
        public int currentValue;
        public boolean forward;
        public boolean shift;
        public boolean control;
    }

    @Override
    public ValueBoxTransform getSlotPositioning() {
        return slotPositioning;
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        return new ValueSettingsBoard(label, behaviour.getMax(), 10, ImmutableList.of(class_2561.method_43470("Value")), new ValueSettingsFormatter());
    }

    @Override
    public ValueSettings getValueSettings() {
        return behaviour.getValueSettings();
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettings valueSetting, boolean ctrlDown) {
        behaviour.setValueSettings(player, valueSetting, ctrlDown);
    }

    @Override
    public boolean mayInteract(class_1657 player) {
        return behaviour.mayInteract(player);
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
        behaviour.onShortInteract(player, hand, side, hitResult);
    }

    @Override
    public int netId() {
        return behaviour.netId();
    }

    @Override
    public boolean onlyVisibleWithWrench() {
        return needsWrench;
    }

}
