package com.zurrtum.create.client.foundation.entity.behaviour;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.entity.behaviour.EntityBehaviour;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_5819;

public class CarriageParticleBehaviour extends EntityBehaviour<CarriageContraptionEntity> {
    public static final BehaviourType<CarriageParticleBehaviour> TYPE = new BehaviourType<>();

    boolean arrived;
    int depressurise;

    double prevMotion;
    LerpedFloat brakes;

    public CarriageParticleBehaviour(CarriageContraptionEntity entity) {
        super(entity);
        this.entity = entity;
        arrived = true;
        depressurise = 0;
        prevMotion = 0;
        brakes = LerpedFloat.linear();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void tick() {
        Contraption contraption = entity.getContraption();
        if (contraption == null)
            return;
        if (!(contraption instanceof CarriageContraption))
            return;
        Carriage carriage = entity.getCarriage();
        if (carriage == null)
            return;
        class_310 mc = class_310.method_1551();
        class_1297 camEntity = mc.method_1560();
        if (camEntity == null)
            return;
        Carriage.DimensionalCarriageEntity dce = carriage.getDimensional(entity.method_73183());
        if (!dce.pointsInitialised)
            return;
        class_243 leadingAnchor = dce.leadingAnchor();
        if (leadingAnchor == null || !leadingAnchor.method_24802(camEntity.method_73189(), 64))
            return;

        class_5819 r = entity.method_73183().field_9229;
        class_243 contraptionMotion = entity.method_73189().method_1020(entity.getPrevPositionVec());
        double length = contraptionMotion.method_1033();
        if (arrived && length > 0.01f)
            arrived = false;
        arrived |= entity.isStalled();

        boolean stopped = length < .002f;
        if (stopped) {
            if (!arrived) {
                arrived = true;
                depressurise = (int) (20 * entity.getCarriage().train.accumulatedSteamRelease / 10f);
            }
        } else
            depressurise = 0;

        if (depressurise > 0)
            depressurise--;

        brakes.chase(prevMotion > length + length / 512f ? 1 : 0, .25f, Chaser.exp(.625f));
        brakes.tickChaser();
        prevMotion = length;

        class_1937 level = entity.method_73183();
        class_243 position = entity.method_30950(0);
        float viewYRot = entity.method_5705(0);
        float viewXRot = entity.method_5695(0);
        int bogeySpacing = entity.getCarriage().bogeySpacing;

        for (CarriageBogey bogey : entity.getCarriage().bogeys) {
            if (bogey == null)
                continue;

            boolean spark = depressurise == 0 || depressurise > 10;

            float cutoff = length < 1 / 8f ? 0 : 1 / 8f;

            if (length > 1 / 6f)
                cutoff = Math.max(cutoff, brakes.getValue() * 1.15f);

            for (int j : Iterate.positiveAndNegative) {
                if (r.method_43057() > cutoff && (spark || r.method_43048(4) == 0))
                    continue;
                for (int i : Iterate.positiveAndNegative) {
                    if (r.method_43057() > cutoff && (spark || r.method_43048(4) == 0))
                        continue;

                    class_243 v = class_243.field_1353.method_1031(j * 1.15, spark ? -.6f : .32, i);
                    class_243 m = class_243.field_1353.method_1031(j * (spark ? .5 : .25), spark ? .49 : -.29, 0);

                    m = VecHelper.rotate(m, bogey.pitch.getValue(0), class_2351.field_11048);
                    m = VecHelper.rotate(m, bogey.yaw.getValue(0), class_2351.field_11052);

                    v = VecHelper.rotate(v, bogey.pitch.getValue(0), class_2351.field_11048);
                    v = VecHelper.rotate(v, bogey.yaw.getValue(0), class_2351.field_11052);

                    v = VecHelper.rotate(v, -viewYRot - 90, class_2351.field_11052);
                    v = VecHelper.rotate(v, viewXRot, class_2351.field_11048);
                    v = VecHelper.rotate(v, -180, class_2351.field_11052);

                    v = v.method_1031(0, 0, bogey.isLeading ? 0 : -bogeySpacing);
                    v = VecHelper.rotate(v, 180, class_2351.field_11052);
                    v = VecHelper.rotate(v, -viewXRot, class_2351.field_11048);
                    v = VecHelper.rotate(v, viewYRot + 90, class_2351.field_11052);
                    v = v.method_1019(position);

                    m = m.method_1019(contraptionMotion.method_1021(.75f));

                    level.method_8406(spark ? bogey.getStyle().contactParticle : bogey.getStyle().smokeParticle, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
                }
            }
        }

    }
}
