package com.zurrtum.create.client.foundation.gui.render;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.compat.sodium.SodiumCompat;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import java.util.List;
import net.minecraft.class_10889;
import net.minecraft.class_11239;
import net.minecraft.class_12249;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4770;
import net.minecraft.class_5819;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_9326;

public class FanRenderer extends class_11239<FanRenderState> {
    private static final class_5819 RANDOM = class_5819.method_43047();

    public FanRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    protected void renderToTexture(FanRenderState state, class_4587 matrices) {
        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        matrices.method_22905(1, 1, -1);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(22.5f));
        matrices.method_46416(-0.92f, -0.75f, -0.5f);
        matrices.method_22905(1, -1, 1);

        class_2680 blockState;
        List<class_10889> parts;
        class_776 blockRenderManager = mc.method_1541();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        class_4588 buffer = field_59933.method_73477(class_4722.method_24074());

        matrices.method_22903();
        blockState = class_2246.field_10124.method_9564();
        parts = List.of(AllPartialModels.ENCASED_FAN_INNER.get());
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(getCurrentAngle() * 16));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        matrices.method_22903();
        blockState = AllBlocks.ENCASED_FAN.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        matrices.method_46416(0, 0, 2);
        blockState = state.target();
        class_3610 fluidState = blockState.method_26227();
        if (!fluidState.method_15769()) {
            class_3611 fluid = fluidState.method_15772();
            SodiumCompat.markFluidSpriteActive(fluid);
            FluidRenderHelper.renderFluidBox(
                fluid,
                class_9326.field_49588,
                0,
                0,
                0,
                1,
                1,
                1,
                field_59933,
                matrices,
                class_765.field_32767,
                false,
                true
            );
            return;
        }
        world.blockState(blockState);
        RANDOM.method_43052(blockState.method_26190(class_2338.field_10980));
        parts = blockRenderManager.method_3349(blockState).method_68512(RANDOM);
        if (blockState.method_26204() instanceof class_4770) {
            buffer = field_59933.method_73477(class_12249.method_75972());
        }
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
    }

    public static float getCurrentAngle() {
        return (AnimationTickHolder.getRenderTime() * 4f) % 360;
    }

    @Override
    protected String method_70906() {
        return "Fan";
    }

    @Override
    public Class<FanRenderState> method_70903() {
        return FanRenderState.class;
    }
}
