package com.zurrtum.create.client.foundation.ponder;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.data.FunctionalHelper;
import com.zurrtum.create.client.content.contraptions.glue.SuperGlueSelectionHandler;
import com.zurrtum.create.client.foundation.ponder.element.BeltItemElement;
import com.zurrtum.create.client.foundation.ponder.element.ExpandedParrotElement;
import com.zurrtum.create.client.foundation.ponder.instruction.AnimateBlockEntityInstruction;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.PonderSceneBuilder;
import com.zurrtum.create.client.ponder.foundation.element.ElementLinkImpl;
import com.zurrtum.create.client.ponder.foundation.instruction.CreateParrotInstruction;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.fluids.pump.PumpBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.infrastructure.particle.RotationIndicatorParticleData;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1453;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_6903;

public class CreateSceneBuilder extends PonderSceneBuilder {

    private final EffectInstructions effects;
    private final WorldInstructions world;
    private final SpecialInstructions special;

    public CreateSceneBuilder(SceneBuilder baseSceneBuilder) {
        this(baseSceneBuilder.getScene());
    }

    private CreateSceneBuilder(PonderScene ponderScene) {
        super(ponderScene);
        effects = new EffectInstructions();
        world = new WorldInstructions();
        special = new SpecialInstructions();
    }

    public EffectInstructions effects() {
        return effects;
    }

    public WorldInstructions world() {
        return world;
    }

    public SpecialInstructions special() {
        return special;
    }

    public class EffectInstructions extends PonderEffectInstructions {

        public void superGlue(class_2338 pos, class_2350 side, boolean fullBlock) {
            addInstruction(scene -> SuperGlueSelectionHandler.spawnParticles(scene.getLevel(), pos, side, fullBlock));
        }

        private void rotationIndicator(class_2338 pos, boolean direction, class_2338 displayPos) {
            addInstruction(scene -> {
                class_2680 blockState = scene.getLevel().method_8320(pos);
                class_2586 blockEntity = scene.getLevel().method_8321(pos);

                if (!(blockState.method_26204() instanceof KineticBlock kb))
                    return;
                if (!(blockEntity instanceof KineticBlockEntity kbe))
                    return;

                class_2350.class_2351 rotationAxis = kb.getRotationAxis(blockState);

                float speed = kbe.getTheoreticalSpeed();
                IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
                int color = direction ? speed > 0 ? 0xeb5e0b : 0x1687a7 : speedLevel.getColor();
                int particleSpeed = speedLevel.getParticleSpeed();
                particleSpeed *= Math.signum(speed);

                class_243 location = VecHelper.getCenterOf(displayPos);
                RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(
                    color,
                    particleSpeed,
                    kb.getParticleInitialRadius(),
                    kb.getParticleTargetRadius(),
                    20,
                    rotationAxis
                );

                for (int i = 0; i < 20; i++)
                    scene.getLevel().method_8406(particleData, location.field_1352, location.field_1351, location.field_1350, 0, 0, 0);
            });
        }

        public void rotationSpeedIndicator(class_2338 pos) {
            rotationIndicator(pos, false, pos);
        }

        public void rotationDirectionIndicator(class_2338 pos) {
            rotationIndicator(pos, true, pos);
        }


    }

    public class WorldInstructions extends PonderWorldInstructions {

        public void rotateBearing(class_2338 pos, float angle, int duration) {
            addInstruction(AnimateBlockEntityInstruction.bearing(pos, angle, duration));
        }

        public void movePulley(class_2338 pos, float distance, int duration) {
            addInstruction(AnimateBlockEntityInstruction.pulley(pos, distance, duration));
        }

        public void animateBogey(class_2338 pos, float distance, int duration) {
            addInstruction(AnimateBlockEntityInstruction.bogey(pos, distance, duration + 1));
        }

        public void moveDeployer(class_2338 pos, float distance, int duration) {
            addInstruction(AnimateBlockEntityInstruction.deployer(pos, distance, duration));
        }

        public void createItemOnBeltLike(class_2338 location, class_2350 insertionSide, class_1799 stack) {
            addInstruction(scene -> {
                PonderLevel world = scene.getLevel();
                class_2586 blockEntity = world.method_8321(location);
                if (!(blockEntity instanceof SmartBlockEntity beltBlockEntity))
                    return;
                DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                if (behaviour == null)
                    return;
                behaviour.handleInsertion(stack, insertionSide.method_10153(), false);
            });
            flapFunnel(location.method_10084(), true);
        }

        public ElementLink<BeltItemElement> createItemOnBelt(class_2338 beltLocation, class_2350 insertionSide, class_1799 stack) {
            ElementLink<BeltItemElement> link = new ElementLinkImpl<>(BeltItemElement.class);
            addInstruction(scene -> {
                PonderLevel world = scene.getLevel();
                class_2586 blockEntity = world.method_8321(beltLocation);
                if (!(blockEntity instanceof BeltBlockEntity beltBlockEntity))
                    return;

                DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                behaviour.handleInsertion(stack, insertionSide.method_10153(), false);

                BeltBlockEntity controllerBE = beltBlockEntity.getControllerBE();
                if (controllerBE != null)
                    controllerBE.tick();

                TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                transporter.handleProcessingOnAllItems(tis -> {
                    BeltItemElement tracker = new BeltItemElement(tis);
                    scene.addElement(tracker);
                    scene.linkElement(tracker, link);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                });
            });
            flapFunnel(beltLocation.method_10084(), true);
            return link;
        }

        public void removeItemsFromBelt(class_2338 beltLocation) {
            addInstruction(scene -> {
                PonderLevel world = scene.getLevel();
                class_2586 blockEntity = world.method_8321(beltLocation);
                if (!(blockEntity instanceof SmartBlockEntity beltBlockEntity))
                    return;
                TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                if (transporter == null)
                    return;
                transporter.handleCenteredProcessingOnAllItems(.52f, tis -> TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            });
        }

        public void stallBeltItem(ElementLink<BeltItemElement> link, boolean stalled) {
            addInstruction(scene -> {
                BeltItemElement resolve = scene.resolve(link);
                if (resolve != null)
                    resolve.ifPresent(tis -> tis.locked = stalled);
            });
        }

        public void changeBeltItemTo(ElementLink<BeltItemElement> link, class_1799 newStack) {
            addInstruction(scene -> {
                BeltItemElement resolve = scene.resolve(link);
                if (resolve != null)
                    resolve.ifPresent(tis -> tis.stack = newStack);
            });
        }

        public void setKineticSpeed(Selection selection, float speed) {
            modifyKineticSpeed(selection, f -> speed);
        }

        public void multiplyKineticSpeed(Selection selection, float modifier) {
            modifyKineticSpeed(selection, f -> f * modifier);
        }

        public void modifyKineticSpeed(Selection selection, UnaryOperator<Float> speedFunc) {
            modifyBlockEntityNBT(
                selection, SpeedGaugeBlockEntity.class, nbt -> {
                    float newSpeed = speedFunc.apply(nbt.method_66563("Speed", 0));
                    nbt.method_10548("Value", SpeedGaugeBlockEntity.getDialTarget(newSpeed));
                }
            );
            modifyBlockEntityNBT(
                selection, KineticBlockEntity.class, nbt -> {
                    nbt.method_10548("Speed", speedFunc.apply(nbt.method_66563("Speed", 0)));
                }
            );
        }

        public void propagatePipeChange(class_2338 pos) {
            modifyBlockEntity(pos, PumpBlockEntity.class, be -> be.onSpeedChanged(0));
        }

        public void setFilterData(Selection selection, Class<? extends class_2586> teType, class_1799 filter) {
            modifyBlockEntityNBT(
                selection, teType, nbt -> {
                    if (!filter.method_7960()) {
                        class_6903<class_2520> ops = world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                        nbt.method_67493("Filter", class_1799.field_24671, ops, filter);
                    }
                }
            );
        }

        public void instructArm(class_2338 armLocation, ArmBlockEntity.Phase phase, class_1799 heldItem, int targetedPoint) {
            modifyBlockEntityNBT(
                scene.getSceneBuildingUtil().select().position(armLocation), ArmBlockEntity.class, compound -> {
                    compound.method_67494("Phase", ArmBlockEntity.Phase.CODEC, phase);
                    if (!heldItem.method_7960()) {
                        class_6903<class_2520> ops = world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                        compound.method_67493("HeldItem", class_1799.field_24671, ops, heldItem);
                    } else {
                        compound.method_10551("HeldItem");
                    }
                    compound.method_10569("TargetPointIndex", targetedPoint);
                    compound.method_10548("MovementProgress", 0);
                }
            );
        }

        public void flapFunnel(class_2338 position, boolean outward) {
            modifyBlockEntity(position, FunnelBlockEntity.class, funnel -> funnel.flap(!outward));
        }

        public void setCraftingResult(class_2338 crafter, class_1799 output) {
            modifyBlockEntity(crafter, MechanicalCrafterBlockEntity.class, mct -> mct.setScriptedResult(output));
        }

        public void connectCrafterInvs(class_2338 position1, class_2338 position2) {
            addInstruction(s -> {
                ConnectedInputHandler.toggleConnection(s.getLevel(), position1, position2);
                s.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
            });
        }

        public void toggleControls(class_2338 position) {
            cycleBlockProperty(position, ControlsBlock.VIRTUAL);
        }

        public void animateTrainStation(class_2338 position, boolean trainPresent) {
            modifyBlockEntityNBT(
                getScene().getSceneBuildingUtil().select().position(position),
                StationBlockEntity.class,
                c -> c.method_10556("ForceFlag", trainPresent)
            );
        }

        public void conductorBlaze(class_2338 position, boolean conductor) {
            modifyBlockEntityNBT(
                getScene().getSceneBuildingUtil().select().position(position),
                BlazeBurnerBlockEntity.class,
                c -> c.method_10556("TrainHat", conductor)
            );
        }

        public void changeSignalState(class_2338 position, SignalBlockEntity.SignalState state) {
            modifyBlockEntityNBT(
                getScene().getSceneBuildingUtil().select().position(position),
                SignalBlockEntity.class,
                c -> c.method_67494("State", SignalBlockEntity.SignalState.CODEC, state)
            );
        }

        public void setDisplayBoardText(class_2338 position, int line, class_2561 text) {
            modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.applyTextManually(line, text));
        }

        public void dyeDisplayBoard(class_2338 position, int line, class_1767 color) {
            modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.setColour(line, color));
        }

        public void flashDisplayLink(class_2338 position) {
            modifyBlockEntity(position, LinkWithBulbBlockEntity.class, LinkWithBulbBlockEntity::pulse);
        }

        @Override
        public void restoreBlocks(Selection selection) {
            super.restoreBlocks(selection);
            markSmartBlockEntityVirtual(selection);
        }

        @Override
        public void setBlocks(Selection selection, class_2680 state, boolean spawnParticles) {
            super.setBlocks(selection, state, spawnParticles);
            markSmartBlockEntityVirtual(selection);
        }

        @Override
        public void modifyBlocks(Selection selection, UnaryOperator<class_2680> stateFunc, boolean spawnParticles) {
            super.modifyBlocks(selection, stateFunc, spawnParticles);
            markSmartBlockEntityVirtual(selection);
        }

        private void markSmartBlockEntityVirtual(Selection selection) {
            addInstruction(scene -> selection.forEach(pos -> {
                if (scene.getLevel().method_8321(pos) instanceof SmartBlockEntity smartBlockEntity)
                    smartBlockEntity.markVirtual();
            }));
        }
    }

    public class SpecialInstructions extends PonderSpecialInstructions {

        @Override
        public ElementLink<ParrotElement> createBirb(class_243 location, Supplier<? extends ParrotPose> pose) {
            ElementLink<ParrotElement> link = new ElementLinkImpl<>(ParrotElement.class);
            ParrotElement parrot = ExpandedParrotElement.create(location, pose);
            addInstruction(new CreateParrotInstruction(10, class_2350.field_11033, parrot));
            addInstruction(scene -> scene.linkElement(parrot, link));
            return link;
        }

        public ElementLink<ParrotElement> birbOnTurntable(class_2338 pos) {
            return createBirb(VecHelper.getCenterOf(pos), () -> new ParrotSpinOnComponentPose(pos));
        }

        public ElementLink<ParrotElement> birbOnSpinnyShaft(class_2338 pos) {
            return createBirb(VecHelper.getCenterOf(pos).method_1031(0, 0.5, 0), () -> new ParrotSpinOnComponentPose(pos));
        }

        public void conductorBirb(ElementLink<ParrotElement> birb, boolean conductor) {
            addInstruction(scene -> scene.resolveOptional(birb).map(FunctionalHelper.filterAndCast(ExpandedParrotElement.class))
                .ifPresent(expandedBirb -> expandedBirb.setConductor(conductor)));
        }

        public static class ParrotSpinOnComponentPose extends ParrotPose {
            private final class_2338 componentPos;

            public ParrotSpinOnComponentPose(class_2338 componentPos) {
                this.componentPos = componentPos;
            }

            @Override
            public void tick(PonderScene scene, class_1453 entity, class_243 location) {
                class_2586 blockEntity = scene.getLevel().method_8321(componentPos);
                if (!(blockEntity instanceof KineticBlockEntity))
                    return;
                float rpm = ((KineticBlockEntity) blockEntity).getSpeed();
                entity.field_5982 = entity.method_36454();
                entity.method_36456(entity.field_5982 + (rpm * .3f));
            }
        }
    }

}