package com.zurrtum.create.client.foundation.utility;

import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.catnip.lang.LangNumberFormat;
import com.zurrtum.create.infrastructure.fluids.FluidStack;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5250;

import static com.zurrtum.create.Create.MOD_ID;

public class CreateLang extends Lang {

    /**
     * legacy-ish. Use CreateLang.translate and other builder methods where possible
     */
    public static class_5250 translateDirect(String key, Object... args) {
        Object[] args1 = LangBuilder.resolveBuilders(args);
        return class_2561.method_43469(MOD_ID + "." + key, args1);
    }

    public static List<class_2561> translatedOptions(String prefix, String... keys) {
        List<class_2561> result = new ArrayList<>(keys.length);
        for (String key : keys)
            result.add(translate((prefix != null ? prefix + "." : "") + key).component());
        return result;
    }

    //

    public static LangBuilder builder() {
        return new LangBuilder(MOD_ID);
    }

    public static LangBuilder blockName(class_2680 state) {
        return builder().add(state.method_26204().method_9518());
    }

    public static LangBuilder itemName(class_1799 stack) {
        return builder().add(stack.method_7964().method_27661());
    }

    public static LangBuilder fluidName(FluidStack stack) {
        return builder().add(stack.getName().method_27661());
    }

    public static LangBuilder number(double d) {
        return builder().text(LangNumberFormat.format(d));
    }

    public static LangBuilder translate(String langKey, Object... args) {
        return builder().translate(langKey, args);
    }

    public static LangBuilder text(String text) {
        return builder().text(text);
    }

    @Deprecated // Use while implementing and replace all references with Lang.translate
    public static LangBuilder temporaryText(String text) {
        return builder().text(text);
    }

}
