package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity.CasingType;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_10801;
import net.minecraft.class_10817;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_5611;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public class BeltModel extends WrapperBlockStateModel {
    public BeltModel(class_2680 state, class_9979 unbaked) {
        super(state, unbaked);
    }

    private static final SpriteShiftEntry SPRITE_SHIFT = AllSpriteShifts.ANDESIDE_BELT_CASING;

    @Override
    public class_1058 particleSpriteWithInfo(class_1920 world, class_2338 pos, class_2680 state) {
        if (world.method_8321(pos) instanceof BeltBlockEntity blockEntity && blockEntity.casing == CasingType.ANDESITE) {
            return AllSpriteShifts.ANDESITE_CASING.getOriginal();
        } else {
            return model.method_68511();
        }
    }

    @Override
    public void addPartsWithInfo(class_1920 world, class_2338 pos, class_2680 state, class_5819 random, List<class_10889> parts) {
        BeltBlockEntity blockentity = (BeltBlockEntity) world.method_8321(pos);
        if (blockentity == null || blockentity.casing == CasingType.NONE) {
            model.method_68513(random, parts);
            return;
        }
        if (blockentity.casing == CasingType.BRASS) {
            model.method_68513(random, parts);
            if (blockentity.covered) {
                boolean alongX = state.method_11654(BeltBlock.HORIZONTAL_FACING).method_10166() == class_2351.field_11048;
                parts.add(alongX ? AllPartialModels.BRASS_BELT_COVER_X.get() : AllPartialModels.BRASS_BELT_COVER_Z.get());
            }
            return;
        }
        class_1058 original = SPRITE_SHIFT.getOriginal();
        if (blockentity.covered) {
            boolean alongX = state.method_11654(BeltBlock.HORIZONTAL_FACING).method_10166() == class_2351.field_11048;
            parts.add(replaceQuads(original, alongX ? AllPartialModels.ANDESITE_BELT_COVER_X.get() : AllPartialModels.ANDESITE_BELT_COVER_Z.get()));
        }
        for (class_10889 part : model.method_68512(random)) {
            parts.add(replaceQuads(original, part));
        }
    }

    private class_10889 replaceQuads(class_1058 replace, class_10889 part) {
        class_10817.class_10818 builder = new class_10817.class_10818();
        for (class_777 quad : part.method_68509(null)) {
            builder.method_68051(replaceQuad(replace, quad));
        }
        for (class_2350 direction : Iterate.directions) {
            for (class_777 quad : part.method_68509(direction)) {
                builder.method_68053(direction, replaceQuad(replace, quad));
            }
        }
        return new class_10801(builder.method_68050(), part.comp_3751(), part.comp_3752());
    }

    private static long calcSpriteUv(long packedUv) {
        float u = class_5611.method_76641(packedUv);
        float v = class_5611.method_76642(packedUv);
        return class_5611.method_76640(SPRITE_SHIFT.getTargetU(u), SPRITE_SHIFT.getTargetV(v));
    }

    private class_777 replaceQuad(class_1058 replace, class_777 quad) {
        class_1058 original = quad.comp_3724();
        if (original != replace) {
            return quad;
        }
        class_777 newQuad = new class_777(
            quad.comp_5238(),
            quad.comp_5239(),
            quad.comp_5240(),
            quad.comp_5241(),
            calcSpriteUv(quad.comp_5242()),
            calcSpriteUv(quad.comp_5243()),
            calcSpriteUv(quad.comp_5244()),
            calcSpriteUv(quad.comp_5245()),
            quad.comp_3722(),
            quad.comp_3723(),
            quad.comp_3724(),
            quad.comp_3725(),
            quad.comp_3726()
        );
        NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
        return newQuad;
    }
}
