package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.decoration.copycat.CopycatBlock;
import com.zurrtum.create.content.decoration.copycat.CopycatBlockEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1933;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_5819;

public abstract class CopycatModel extends WrapperBlockStateModel {
    public CopycatModel(class_2680 state, class_9979 unbaked) {
        super(state, unbaked);
    }

    public static class_11515 getLayer(class_1920 world, class_2338 pos) {
        return class_4696.method_23679(CopycatBlock.getMaterial(world, pos));
    }

    public static int getColor(class_2680 state, class_1920 world, class_2338 pos, int i) {
        if (world == null || pos == null) {
            return class_1933.method_49724();
        }
        return class_310.method_1551().method_1505().method_1697(CopycatBlock.getMaterial(world, pos), world, pos, i);
    }

    @Override
    public void addPartsWithInfo(class_1920 world, class_2338 pos, class_2680 state, class_5819 random, List<class_10889> parts) {
        if (!(state.method_26204() instanceof CopycatBlock block)) {
            return;
        }
        CopycatBlockEntity copycat = (CopycatBlockEntity) world.method_8321(pos);
        class_2680 material = copycat == null ? AllBlocks.COPYCAT_BASE.method_9564() : copycat.getMaterial();
        addPartsWithInfo(world, pos, state, block, material, random, parts);
    }

    protected abstract void addPartsWithInfo(
        class_1920 world,
        class_2338 pos,
        class_2680 state,
        CopycatBlock block,
        class_2680 material,
        class_5819 random,
        List<class_10889> parts
    );

    protected static class_1087 getModelOf(class_2680 material) {
        return class_310.method_1551().method_1541().method_3349(material);
    }

    @Override
    public class_1058 particleSpriteWithInfo(class_1920 world, class_2338 pos, class_2680 state) {
        CopycatBlockEntity copycat = (CopycatBlockEntity) world.method_8321(pos);
        if (copycat == null) {
            return model.method_68511();
        }
        return getModelOf(copycat.getMaterial()).method_68511();
    }

    protected void addModelParts(
        class_1920 world,
        class_2338 pos,
        class_2680 material,
        class_5819 random,
        class_1087 model,
        List<class_10889> parts
    ) {
        if (WrapperBlockStateModel.unwrapCompat(model) instanceof WrapperBlockStateModel wrapper) {
            wrapper.addPartsWithInfo(world, pos, material, random, parts);
        } else {
            model.method_68513(random, parts);
        }
    }

    protected List<class_10889> getMaterialParts(
        class_1920 world,
        class_2338 pos,
        class_2680 material,
        class_5819 random,
        class_1087 model
    ) {
        List<class_10889> parts = new ObjectArrayList<>();
        addModelParts(world, pos, material, random, model, parts);
        return parts;
    }

    protected OcclusionData gatherOcclusionData(
        class_1920 world,
        class_2338 pos,
        class_2680 state,
        class_2680 material,
        CopycatBlock copycatBlock
    ) {
        OcclusionData occlusionData = new OcclusionData();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (class_2350 face : Iterate.directions) {
            if (!copycatBlock.canFaceBeOccluded(state, face))
                continue;
            if (!class_2248.method_9607(material, world.method_8320(mutablePos.method_25505(pos, face)), face))
                occlusionData.occlude(face);
        }
        return occlusionData;
    }

    protected static class OcclusionData {
        private final boolean[] occluded;

        public OcclusionData() {
            occluded = new boolean[6];
        }

        public void occlude(class_2350 face) {
            occluded[face.method_10146()] = true;
        }

        public boolean isOccluded(class_2350 face) {
            return face != null && occluded[face.method_10146()];
        }
    }
}