package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import org.joml.Vector3fc;

import java.util.List;
import net.minecraft.class_10801;
import net.minecraft.class_10817;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public class FactoryPanelModel extends WrapperBlockStateModel {
    public FactoryPanelModel(class_2680 state, class_9979 unbaked) {
        super(state, unbaked);
    }

    @Override
    public void addPartsWithInfo(class_1920 world, class_2338 pos, class_2680 state, class_5819 random, List<class_10889> parts) {
        model.method_68513(random, parts);
        boolean ponder = world instanceof PonderLevel;
        for (PanelSlot slot : PanelSlot.values()) {
            ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at(world, new FactoryPanelPosition(pos, slot));
            if (behaviour == null)
                continue;
            addPanel(parts, state, slot, behaviour, ponder);
        }
    }

    private static Vector3fc calcXYZ(Vector3fc position, double xOffset, double yOffset, float xRot, float yRot) {
        class_243 vertex = new class_243(position);
        vertex = vertex.method_1031(xOffset, 0, yOffset);
        vertex = VecHelper.rotateCentered(vertex, 180, class_2351.field_11052);
        vertex = VecHelper.rotateCentered(vertex, xRot, class_2351.field_11048);
        vertex = VecHelper.rotateCentered(vertex, yRot, class_2351.field_11052);
        return vertex.method_46409();
    }

    public void addPanel(List<class_10889> parts, class_2680 state, PanelSlot slot, ServerFactoryPanelBehaviour behaviour, boolean ponder) {
        PartialModel factoryPanel;
        if (behaviour.panelBE().restocker) {
            factoryPanel = behaviour.count == 0 ? AllPartialModels.FACTORY_PANEL_RESTOCKER : AllPartialModels.FACTORY_PANEL_RESTOCKER_WITH_BULB;
        } else {
            factoryPanel = behaviour.count == 0 ? AllPartialModels.FACTORY_PANEL : AllPartialModels.FACTORY_PANEL_WITH_BULB;
        }

        float xRot = class_3532.field_29848 * FactoryPanelBlock.getXRot(state) + 90;
        float yRot = class_3532.field_29848 * FactoryPanelBlock.getYRot(state);
        double xOffset = slot.xOffset * .5;
        double yOffset = slot.yOffset * .5;
        int normal = 127 << 16;
        int[] normals = new int[]{normal, normal, normal, normal};

        class_10801 model = factoryPanel.get();
        class_10817.class_10818 builder = new class_10817.class_10818();
        for (class_777 bakedQuad : model.comp_3750().method_68048()) {
            class_243 quadNormal = class_243.method_24954(bakedQuad.comp_3723().method_62675());
            quadNormal = VecHelper.rotate(quadNormal, 180, class_2351.field_11052);
            quadNormal = VecHelper.rotate(quadNormal, xRot, class_2351.field_11048);
            quadNormal = VecHelper.rotate(quadNormal, yRot, class_2351.field_11052);
            class_2350 newNormal = class_2350.method_62672(
                (int) Math.round(quadNormal.field_1352),
                (int) Math.round(quadNormal.field_1351),
                (int) Math.round(quadNormal.field_1350),
                null
            );
            class_777 quad = new class_777(
                calcXYZ(bakedQuad.comp_5238(), xOffset, yOffset, xRot, yRot),
                calcXYZ(bakedQuad.comp_5239(), xOffset, yOffset, xRot, yRot),
                calcXYZ(bakedQuad.comp_5240(), xOffset, yOffset, xRot, yRot),
                calcXYZ(bakedQuad.comp_5241(), xOffset, yOffset, xRot, yRot),
                bakedQuad.comp_5242(),
                bakedQuad.comp_5243(),
                bakedQuad.comp_5244(),
                bakedQuad.comp_5245(),
                bakedQuad.comp_3722(),
                newNormal,
                bakedQuad.comp_3724(),
                !ponder && bakedQuad.comp_3725(),
                bakedQuad.comp_3726()
            );
            NormalsBakedQuad.setNormals(quad, normals);
            builder.method_68051(quad);
        }
        parts.add(new class_10801(builder.method_68050(), model.comp_3751(), model.comp_3752()));
    }
}
