package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllCTBehaviours;
import com.zurrtum.create.client.foundation.block.connected.ConnectedTextureBehaviour;

import java.util.List;
import net.minecraft.class_10801;
import net.minecraft.class_10817;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;

public class FluidTankModel extends CTModel {
    public FluidTankModel(class_2680 state, class_9979 unbaked, ConnectedTextureBehaviour behaviour) {
        super(state, unbaked, behaviour);
    }

    public static FluidTankModel standard(class_2680 state, class_9979 unbaked) {
        return new FluidTankModel(state, unbaked, AllCTBehaviours.FLUID_TANK);
    }

    public static FluidTankModel creative(class_2680 state, class_9979 unbaked) {
        return new FluidTankModel(state, unbaked, AllCTBehaviours.CREATIVE_FLUID_TANK);
    }

    @Override
    public void addPartsWithInfo(class_1920 world, class_2338 pos, class_2680 state, class_5819 random, List<class_10889> parts) {
        int[] indices = createCTData(world, pos, state);
        boolean[] culls = createCullData(world, pos);
        for (class_10889 part : model.method_68512(random)) {
            class_10817.class_10818 builder = new class_10817.class_10818();
            for (class_777 quad : part.method_68509(null)) {
                builder.method_68051(replaceQuad(state, random, indices[quad.comp_3723().method_10146()], quad));
            }
            for (class_2350 direction : Iterate.directions) {
                int i = direction.method_10161();
                if (i != -1 && culls[i]) {
                    continue;
                }
                addQuads(builder, part, direction, state, random, indices[direction.method_10146()]);
            }
            parts.add(new class_10801(builder.method_68050(), part.comp_3751(), part.comp_3752()));
        }
    }

    protected boolean[] createCullData(class_1920 world, class_2338 pos) {
        boolean[] culledFaces = new boolean[4];
        for (class_2350 face : Iterate.horizontalDirections) {
            culledFaces[face.method_10161()] = ConnectivityHandler.isConnected(world, pos, pos.method_10093(face));
        }
        return culledFaces;
    }
}
