package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_811;
import net.minecraft.client.renderer.item.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

import java.util.List;
import java.util.function.Supplier;

import static com.zurrtum.create.Create.MOD_ID;

public class GogglesModel implements class_10439 {
    public static final class_2960 ID = class_2960.method_60655(MOD_ID, "model/goggles");
    public static final class_2960 ITEM_ID = class_2960.method_60655(MOD_ID, "item/goggles");
    public static final class_2960 BLOCK_ID = class_2960.method_60655(MOD_ID, "block/goggles");

    private final class_1921 itemLayer = class_4722.method_29382();
    private final class_1921 blockLayer = class_4722.method_76545();
    private final List<class_777> itemQuads;
    private final class_10809 itemSettings;
    private final Supplier<Vector3fc[]> itemVector;
    private final List<class_777> blockQuads;
    private final class_10809 blockSettings;
    private final Supplier<Vector3fc[]> blockVector;

    public GogglesModel(class_3545<List<class_777>, class_10809> item, class_3545<List<class_777>, class_10809> block) {
        itemQuads = item.method_15442();
        itemSettings = item.method_15441();
        itemVector = Suppliers.memoize(() -> class_10430.method_67990(itemQuads));
        blockQuads = block.method_15442();
        blockSettings = block.method_15441();
        blockVector = Suppliers.memoize(() -> class_10430.method_67990(blockQuads));
    }

    @Override
    public void method_65584(
        class_10444 state,
        class_1799 stack,
        class_10442 resolver,
        class_811 displayContext,
        @Nullable class_638 world,
        @Nullable class_11566 user,
        int seed
    ) {
        state.method_70946(this);
        if (displayContext == class_811.field_4316) {
            update(state, displayContext, blockLayer, blockQuads, blockSettings, blockVector);
        } else {
            update(state, displayContext, itemLayer, itemQuads, itemSettings, itemVector);
        }
    }

    private void update(
        class_10444 state,
        class_811 displayContext,
        class_1921 layer,
        List<class_777> quads,
        class_10809 settings,
        Supplier<Vector3fc[]> vector
    ) {
        class_10444.class_10446 layerRenderState = state.method_65601();
        layerRenderState.method_67992(layer);
        layerRenderState.method_67995(vector);
        settings.method_68000(layerRenderState, displayContext);
        layerRenderState.method_67997().addAll(quads);
    }

    public static class Unbaked implements class_10439.class_10441 {
        public static final MapCodec<com.zurrtum.create.client.infrastructure.model.GogglesModel.Unbaked> CODEC = MapCodec.unit(com.zurrtum.create.client.infrastructure.model.GogglesModel.Unbaked::new);

        @Override
        public MapCodec<com.zurrtum.create.client.infrastructure.model.GogglesModel.Unbaked> method_65585() {
            return CODEC;
        }

        @Override
        public void method_62326(class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(BLOCK_ID);
        }

        @Override
        public class_10439 method_65587(class_10440 context) {
            class_7775 baker = context.comp_3390();
            return new GogglesModel(bake(baker, ITEM_ID), bake(baker, BLOCK_ID));
        }

        private static class_3545<List<class_777>, class_10809> bake(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            class_10419 textures = model.method_68045();
            List<class_777> quads = model.method_68034(textures, baker, class_1086.field_63619).method_68048();
            class_10809 settings = class_10809.method_68001(baker, model, textures);
            return new class_3545<>(quads, settings);
        }
    }
}
