package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.content.equipment.potatoCannon.PotatoCannonItem;
import com.zurrtum.create.content.equipment.potatoCannon.PotatoCannonItem.Ammo;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10444.class_10446;
import net.minecraft.class_10515;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.client.renderer.item.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Vector3fc;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

import static com.zurrtum.create.Create.MOD_ID;

public class PotatoCannonModel implements class_10439, class_10515<PotatoCannonModel.CogRenderData> {
    public static final class_2960 ID = class_2960.method_60655(MOD_ID, "model/potato_cannon");
    public static final class_2960 ITEM_ID = class_2960.method_60655(MOD_ID, "item/potato_cannon/item");
    public static final class_2960 COG_ID = class_2960.method_60655(MOD_ID, "item/potato_cannon/cog");

    private final class_1921 layer = class_4722.method_29382();
    private final List<class_777> itemQuads;
    private final class_10809 itemSettings;
    private final Supplier<Vector3fc[]> itemVector;
    private final List<class_777> cogQuads;
    private final class_10809 cogSettings;
    private final Supplier<Vector3fc[]> cogVector;

    public PotatoCannonModel(class_3545<List<class_777>, class_10809> item, class_3545<List<class_777>, class_10809> cog) {
        itemQuads = item.method_15442();
        itemSettings = item.method_15441();
        itemVector = Suppliers.memoize(() -> class_10430.method_67990(itemQuads));
        cogQuads = cog.method_15442();
        cogSettings = cog.method_15441();
        cogVector = Suppliers.memoize(() -> class_10430.method_67990(cogQuads));
    }

    @Override
    public void method_65584(
        class_10444 state,
        class_1799 stack,
        class_10442 resolver,
        class_811 displayContext,
        @Nullable class_638 world,
        @Nullable class_11566 user,
        int seed
    ) {
        state.method_70946(this);
        state.method_70947();
        class_10444.class_10445 glint;
        if (stack.method_7958()) {
            state.method_70946(class_10444.class_10445.field_55342);
            glint = class_10444.class_10445.field_55342;
        } else {
            glint = class_10444.class_10445.field_55341;
        }
        update(state, displayContext, itemQuads, itemSettings, itemVector, glint);

        CogRenderData cog = new CogRenderData();
        cog.state = update(state, displayContext, cogQuads, cogSettings, cogVector, glint);
        cog.state.method_67993(itemSettings.comp_3768().method_3503(displayContext));
        cog.rotation = AnimationTickHolder.getRenderTime() * -2.5f;
        boolean inMainHand = displayContext == class_811.field_4322 || displayContext == class_811.field_4320;
        if (inMainHand || displayContext == class_811.field_4321 || displayContext == class_811.field_4323) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                boolean leftHanded = player.method_6068() == class_1306.field_6182;
                float speed = Create.POTATO_CANNON_RENDER_HANDLER.getAnimation(inMainHand ^ leftHanded, AnimationTickHolder.getPartialTicks());
                cog.rotation += 360 * class_3532.method_15363(speed * 5, 0, 1);
            }
        }
        cog.rotation %= 360;
        cog.state.method_65617(this, cog);
    }

    private class_10446 update(
        class_10444 state,
        class_811 displayContext,
        List<class_777> quads,
        class_10809 settings,
        Supplier<Vector3fc[]> vector,
        class_10444.class_10445 glint
    ) {
        class_10446 layerRenderState = state.method_65601();
        layerRenderState.method_67992(layer);
        layerRenderState.method_67995(vector);
        settings.method_68000(layerRenderState, displayContext);
        layerRenderState.method_67997().addAll(quads);
        layerRenderState.method_65615(glint);
        return layerRenderState;
    }

    @Override
    public void submit(
        CogRenderData data,
        class_811 displayContext,
        class_4587 matrices,
        class_11659 queue,
        int light,
        int overlay,
        boolean glint,
        int i
    ) {
        assert data != null;
        matrices.method_46416(0.5f, 0.53125f, 0.5f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(data.rotation));
        matrices.method_46416(-0.5f, -0.53125f, -0.5f);
        class_10446 state = data.state;
        queue.method_73480(matrices, displayContext, light, overlay, 0, state.field_55349, state.method_67997(), state.field_55347, state.field_55348);
    }

    public static void renderDecorator(class_310 client, class_332 drawContext, class_1799 stack, int x, int y) {
        if (client.field_1724 == null) {
            return;
        }
        Ammo ammo = PotatoCannonItem.getAmmo(client.field_1724, stack);
        if (ammo == null) {
            return;
        }
        Matrix3x2fStack matrices = drawContext.method_51448();
        matrices.translate(x, y + 8);
        matrices.scale(0.5f);
        drawContext.method_51427(ammo.stack(), 0, 0);
    }

    public static class CogRenderData {
        class_10446 state;
        float rotation;
    }

    @Override
    public void method_72175(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CogRenderData method_65695(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    public static class Unbaked implements class_10439.class_10441 {
        public static final MapCodec<com.zurrtum.create.client.infrastructure.model.PotatoCannonModel.Unbaked> CODEC = MapCodec.unit(com.zurrtum.create.client.infrastructure.model.PotatoCannonModel.Unbaked::new);

        @Override
        public MapCodec<com.zurrtum.create.client.infrastructure.model.PotatoCannonModel.Unbaked> method_65585() {
            return CODEC;
        }

        @Override
        public void method_62326(class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(COG_ID);
        }

        @Override
        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            return new PotatoCannonModel(bake(baker, ITEM_ID), bake(baker, COG_ID));
        }

        private static class_3545<List<class_777>, class_10809> bake(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            class_10419 textures = model.method_68045();
            List<class_777> quads = model.method_68034(textures, baker, class_1086.field_63619).method_68048();
            class_10809 settings = class_10809.method_68001(baker, model, textures);
            return new class_3545<>(quads, settings);
        }
    }
}
