package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueHandler;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10444.class_10446;
import net.minecraft.class_10515;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.client.renderer.item.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

import static com.zurrtum.create.Create.MOD_ID;

public class WrenchModel implements class_10439, class_10515<class_10446> {
    public static final class_2960 ID = class_2960.method_60655(MOD_ID, "model/wrench");
    public static final class_2960 ITEM_ID = class_2960.method_60655(MOD_ID, "item/wrench/item");
    public static final class_2960 GEAR_ID = class_2960.method_60655(MOD_ID, "item/wrench/gear");

    private final class_1921 layer = class_4722.method_29382();
    private final List<class_777> itemQuads;
    private final class_10809 itemSettings;
    private final Supplier<Vector3fc[]> itemVector;
    private final List<class_777> gearQuads;
    private final class_10809 gearSettings;
    private final Supplier<Vector3fc[]> gearVector;

    public WrenchModel(class_3545<List<class_777>, class_10809> item, class_3545<List<class_777>, class_10809> gear) {
        itemQuads = item.method_15442();
        itemSettings = item.method_15441();
        itemVector = Suppliers.memoize(() -> class_10430.method_67990(itemQuads));
        gearQuads = gear.method_15442();
        gearSettings = gear.method_15441();
        gearVector = Suppliers.memoize(() -> class_10430.method_67990(gearQuads));
    }

    @Override
    public void method_65584(
        class_10444 state,
        class_1799 stack,
        class_10442 resolver,
        class_811 displayContext,
        @Nullable class_638 world,
        @Nullable class_11566 user,
        int seed
    ) {
        state.method_70946(this);
        state.method_70947();
        update(state, displayContext, itemQuads, itemSettings, itemVector, false);
        update(state, displayContext, gearQuads, gearSettings, gearVector, true);
    }

    private void update(
        class_10444 state,
        class_811 displayContext,
        List<class_777> quads,
        class_10809 settings,
        Supplier<Vector3fc[]> vector,
        boolean rotation
    ) {
        class_10446 layerRenderState = state.method_65601();
        layerRenderState.method_67992(layer);
        layerRenderState.method_67995(vector);
        settings.method_68000(layerRenderState, displayContext);
        layerRenderState.method_67997().addAll(quads);
        if (rotation) {
            layerRenderState.method_65617(this, layerRenderState);
        }
    }

    @Override
    public void submit(
        class_10446 layer,
        class_811 displayContext,
        class_4587 matrices,
        class_11659 queue,
        int light,
        int overlay,
        boolean glint,
        int i
    ) {
        assert layer != null;
        matrices.method_22903();
        matrices.method_46416(0.5625f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(ScrollValueHandler.getScroll(AnimationTickHolder.getPartialTicks())));
        matrices.method_46416(-0.5625f, -0.5f, -0.5f);
        queue.method_73480(matrices, displayContext, light, overlay, 0, layer.field_55349, layer.method_67997(), layer.field_55347, layer.field_55348);
        matrices.method_22909();
    }

    @Override
    public void method_72175(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    @Override
    public class_10446 method_65695(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    public static class Unbaked implements class_10439.class_10441 {
        public static final MapCodec<com.zurrtum.create.client.infrastructure.model.WrenchModel.Unbaked> CODEC = MapCodec.unit(com.zurrtum.create.client.infrastructure.model.WrenchModel.Unbaked::new);

        @Override
        public MapCodec<com.zurrtum.create.client.infrastructure.model.WrenchModel.Unbaked> method_65585() {
            return CODEC;
        }

        @Override
        public void method_62326(class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(GEAR_ID);
        }

        @Override
        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            return new WrenchModel(bake(baker, ITEM_ID), bake(baker, GEAR_ID));
        }

        private static class_3545<List<class_777>, class_10809> bake(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            class_10419 textures = model.method_68045();
            List<class_777> quads = model.method_68034(textures, baker, class_1086.field_63619).method_68048();
            class_10809 settings = class_10809.method_68001(baker, model, textures);
            return new class_3545<>(quads, settings);
        }
    }
}
