package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.infrastructure.particle.CubeParticleData;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;

public class CubeParticle extends class_703 {
    protected float scale;
    protected boolean hot;
    protected float red = 1.0F;
    protected float green = 1.0F;
    protected float blue = 1.0F;
    protected float alpha = 1.0F;

    public CubeParticle(class_638 world, CubeParticleData data, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.field_3852 = motionX;
        this.field_3869 = motionY;
        this.field_3850 = motionZ;

        setColor(data.red(), data.green(), data.blue());
        setScale(data.scale());
        averageAge(data.avgAge());
        setHot(data.hot());
    }

    public void setColor(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.method_3080(scale * 0.5f, scale * 0.5f);
    }

    public void averageAge(int age) {
        this.field_3847 = (int) (age + (field_3840.method_43058() * 2D - 1D) * 8);
    }

    public void setHot(boolean hot) {
        this.hot = hot;
    }

    private boolean billowing = false;

    @Override
    public void method_3070() {
        if (this.hot && this.field_3866 > 0) {
            if (this.field_3838 == this.field_3854) {
                billowing = true;
                field_21507 = false; // Prevent motion being ignored due to vertical collision
                if (this.field_3852 == 0 && this.field_3850 == 0) {
                    class_243 diff = class_243.method_24954(class_2338.method_49637(field_3874, field_3854, field_3871)).method_1031(0.5, 0.5, 0.5).method_1023(field_3874, field_3854, field_3871);
                    this.field_3852 = -diff.field_1352 * 0.1;
                    this.field_3850 = -diff.field_1350 * 0.1;
                }
                this.field_3852 *= 1.1;
                this.field_3869 *= 0.9;
                this.field_3850 *= 1.1;
            } else if (billowing) {
                this.field_3869 *= 1.2;
            }
        }
        super.method_3070();
    }

    public void render(CubeParticleSubmittable submittable, class_4184 camera, float tickProgress) {
        class_243 projectedView = camera.method_71156();
        float lerpedX = (float) (class_3532.method_16436(tickProgress, this.field_3858, this.field_3874) - projectedView.method_10216());
        float lerpedY = (float) (class_3532.method_16436(tickProgress, this.field_3838, this.field_3854) - projectedView.method_10214());
        float lerpedZ = (float) (class_3532.method_16436(tickProgress, this.field_3856, this.field_3871) - projectedView.method_10215());
        double ageMultiplier = 1 - Math.pow(class_3532.method_15363(field_3866 + tickProgress, 0, field_3847), 3) / Math.pow(field_3847, 3);
        float scale = (float) (this.scale * ageMultiplier);
        int color = class_9848.method_61318(alpha, red, green, blue);
        submittable.render(lerpedX, lerpedY, lerpedZ, scale, color);
    }

    @Override
    public class_3999 method_74274() {
        return CubeParticleRenderer.SHEET;
    }

    public boolean shouldRender(class_4604 frustum) {
        return frustum.method_74404(field_3874, field_3854, field_3871);
    }

    public static class Factory implements class_707<CubeParticleData> {

        @Override
        public class_703 createParticle(
            CubeParticleData data,
            class_638 world,
            double x,
            double y,
            double z,
            double motionX,
            double motionY,
            double motionZ,
            class_5819 random
        ) {
            return new CubeParticle(world, data, x, y, z, motionX, motionY, motionZ);
        }
    }
}
