package com.zurrtum.create.client.mixin;

import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.infrastructure.fluids.FlowableFluid;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_3610;
import net.minecraft.class_9326;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets = "net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerRegistryImpl$WaterRenderHandler")
public class WaterRenderHandlerMixin {
    @Inject(method = "getFluidSprites(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/FluidState;)[Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", at = @At("HEAD"), cancellable = true)
    private void getSprites(class_1920 view, class_2338 pos, class_3610 state, CallbackInfoReturnable<class_1058[]> cir) {
        if (state.method_15772() instanceof FlowableFluid fluid) {
            FluidConfig config = AllFluidConfigs.get(fluid);
            if (config != null) {
                cir.setReturnValue(new class_1058[]{config.still().get(), config.flowing().get()});
            }
        }
    }

    @Inject(method = "getFluidColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/FluidState;)I", at = @At("HEAD"), cancellable = true)
    private void getTint(class_1920 view, class_2338 pos, class_3610 state, CallbackInfoReturnable<Integer> cir) {
        if (state.method_15772() instanceof FlowableFluid fluid) {
            FluidConfig config = AllFluidConfigs.get(fluid);
            if (config != null) {
                cir.setReturnValue(config.tint().apply(class_9326.field_49588));
            }
        }
    }
}
