/*
 * Copyright (c) NeoForged and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package com.zurrtum.create.client.model;

import com.google.common.collect.Maps;
import com.google.gson.*;
import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.Create;
import com.zurrtum.create.client.model.obj.ObjLoader;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4590;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.client.renderer.block.model.*;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Stream;

public class UnbakedModelParser {
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(class_1100.class, new Deserializer())
        .registerTypeAdapter(class_793.class, new class_793.class_795()).registerTypeAdapter(class_785.class, new class_785.class_786())
        .registerTypeAdapter(class_783.class, new class_783.class_784())
        .registerTypeAdapter(class_804.class, new class_804.class_805())
        .registerTypeAdapter(class_809.class, new class_809.class_810())
        .registerTypeAdapter(class_4590.class, new TransformationHelper.Deserializer()).create();
    private static final Map<class_2960, class_1100> CACHE = Maps.newConcurrentMap();

    public static void cache(class_2960 id, class_1100 model) {
        CACHE.put(id, model);
    }

    public static Stream<Pair<class_2960, class_1100>> getCaches() {
        return CACHE.entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue()));
    }

    public static final class Deserializer implements JsonDeserializer<class_1100> {
        @Override
        public class_1100 deserialize(
            JsonElement jsonElement,
            Type type,
            JsonDeserializationContext jsonDeserializationContext
        ) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();

            if (jsonObject.has("loader")) {
                String loader = class_3518.method_15265(jsonObject, "loader");
                if (loader.equals("neoforge:obj")) {
                    return ObjLoader.INSTANCE.read(jsonObject, jsonDeserializationContext);
                }
                Create.LOGGER.warn("Unsupported loader: " + loader);
            }

            return jsonDeserializationContext.deserialize(jsonObject, class_793.class);
        }
    }
}
