package com.zurrtum.create.client.ponder.foundation;


import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.ponder.api.scene.*;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3341;

/**
 * Helpful shortcuts for marking boundaries, points or sections inside the scene
 */
public class PonderSceneBuildingUtil implements SceneBuildingUtil {

    private final SelectionUtil select;
    private final VectorUtil vector;
    private final PositionUtil grid;

    private final class_3341 sceneBounds;

    PonderSceneBuildingUtil(class_3341 sceneBounds) {
        this.sceneBounds = sceneBounds;
        this.select = new PonderSelectionUtil();
        this.vector = new PonderVectorUtil();
        this.grid = new PonderPositionUtil();
    }

    @Override
    public SelectionUtil select() {
        return select;
    }

    @Override
    public VectorUtil vector() {
        return vector;
    }

    @Override
    public PositionUtil grid() {
        return grid;
    }

    public static class PonderPositionUtil implements PositionUtil {

        @Override
        public class_2338 at(int x, int y, int z) {
            return new class_2338(x, y, z);
        }

        @Override
        public class_2338 zero() {
            return at(0, 0, 0);
        }

    }

    public class PonderVectorUtil implements VectorUtil {

        @Override
        public class_243 centerOf(int x, int y, int z) {
            return centerOf(grid().at(x, y, z));
        }

        @Override
        public class_243 centerOf(class_2338 pos) {
            return VecHelper.getCenterOf(pos);
        }

        @Override
        public class_243 topOf(int x, int y, int z) {
            return blockSurface(grid().at(x, y, z), class_2350.field_11036);
        }

        @Override
        public class_243 topOf(class_2338 pos) {
            return blockSurface(pos, class_2350.field_11036);
        }

        @Override
        public class_243 blockSurface(class_2338 pos, class_2350 face) {
            return blockSurface(pos, face, 0);
        }

        @Override
        public class_243 blockSurface(class_2338 pos, class_2350 face, float margin) {
            return centerOf(pos).method_1019(class_243.method_24954(face.method_62675()).method_1021(.5f + margin));
        }

        @Override
        public class_243 of(double x, double y, double z) {
            return new class_243(x, y, z);
        }

    }

    public class PonderSelectionUtil implements SelectionUtil {

        @Override
        public Selection everywhere() {
            return SelectionImpl.of(sceneBounds);
        }

        @Override
        public Selection position(int x, int y, int z) {
            return position(grid().at(x, y, z));
        }

        @Override
        public Selection position(class_2338 pos) {
            return cuboid(pos, class_2338.field_10980);
        }

        @Override
        public Selection fromTo(int x, int y, int z, int x2, int y2, int z2) {
            return fromTo(new class_2338(x, y, z), new class_2338(x2, y2, z2));
        }

        @Override
        public Selection fromTo(class_2338 pos1, class_2338 pos2) {
            return cuboid(pos1, pos2.method_10059(pos1));
        }

        @Override
        public Selection column(int x, int z) {
            return cuboid(new class_2338(x, 1, z), new class_2382(0, sceneBounds.method_14660(), 0));
        }

        @Override
        public Selection layer(int y) {
            return layers(y, 1);
        }

        @Override
        public Selection layersFrom(int y) {
            return layers(y, sceneBounds.method_14660() - y);
        }

        @Override
        public Selection layers(int y, int height) {
            return cuboid(
                new class_2338(0, y, 0),
                new class_2382(sceneBounds.method_35414() - 1, Math.min(sceneBounds.method_14660() - y, height) - 1, sceneBounds.method_14663() - 1)
            );
        }

        @Override
        public Selection cuboid(class_2338 origin, class_2382 size) {
            return SelectionImpl.of(class_3341.method_34390(origin, origin.method_10081(size)));
        }

    }

}