package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement.GuiItemRenderBuilder;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.ponder.Ponder;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class PonderTag implements ScreenElement {

    /**
     * Highlight.ALL is a special PonderTag, used to indicate that all Tags
     * for a certain Scene should be highlighted instead of selected single ones
     */
    public static final class Highlight {
        public static final class_2960 ALL = Ponder.asResource("_all");
    }

    private final class_2960 id;
    @Nullable
    private final class_2960 textureIconLocation;
    private final class_1799 mainItem;
    private final GuiItemRenderBuilder itemIcon;


    public PonderTag(class_2960 id, @Nullable class_2960 textureIconLocation, class_1799 itemIcon, class_1799 mainItem) {
        this.id = id;
        this.textureIconLocation = textureIconLocation;
        this.mainItem = mainItem;
        if (textureIconLocation == null && !itemIcon.method_7960()) {
            this.itemIcon = GuiGameElement.of(itemIcon).scale(1.25f).at(-2, -2);
        } else {
            this.itemIcon = null;
        }
    }

    public class_2960 getId() {
        return id;
    }

    public class_1799 getMainItem() {
        return mainItem;
    }

    public String getTitle() {
        return PonderIndex.getLangAccess().getTagName(id);
    }

    public String getDescription() {
        return PonderIndex.getLangAccess().getTagDescription(id);
    }

    public void render(class_332 graphics, int x, int y) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(x, y);
        if (textureIconLocation != null) {
            //RenderSystem.setShaderTexture(0, icon);
            poseStack.scale(0.25f, 0.25f);
            graphics.method_25291(class_10799.field_56883, textureIconLocation, 0, 0, 0, 0, 0, 64, 64, 64, 64);
        } else if (itemIcon != null) {
            itemIcon.render(graphics);
        }
        poseStack.popMatrix();
    }

    public void clear() {
        if (itemIcon != null) {
            itemIcon.clear();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other)
            return true;

        if (!(other instanceof PonderTag otherTag))
            return false;

        return getId().equals(otherTag.getId());
    }
}