package com.zurrtum.create.client.ponder.foundation.element;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.ponder.api.element.AnimatedSceneElement;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import net.minecraft.class_10442;
import net.minecraft.class_11515;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_898;

public abstract class AnimatedSceneElementBase extends PonderElementBase implements AnimatedSceneElement {

    protected class_243 fadeVec;
    protected LerpedFloat fade;

    public AnimatedSceneElementBase() {
        fade = LerpedFloat.linear().startWithValue(0);
    }

    @Override
    public void forceApplyFade(float fade) {
        this.fade.startWithValue(fade);
    }

    @Override
    public void setFade(float fade) {
        this.fade.setValue(fade);
    }

    @Override
    public void setFadeVec(class_243 fadeVec) {
        this.fadeVec = fadeVec;
    }

    @Override
    public final void renderFirst(
        class_824 blockEntityRenderDispatcher,
        class_776 blockRenderManager,
        PonderLevel world,
        class_4597 buffer,
        class_11659 queue,
        class_4184 camera,
        class_12075 cameraRenderState,
        class_4587 poseStack,
        float pt
    ) {
        poseStack.method_22903();
        float currentFade = applyFade(poseStack, pt);
        renderFirst(blockEntityRenderDispatcher, blockRenderManager, world, buffer, queue, camera, cameraRenderState, poseStack, currentFade, pt);
        poseStack.method_22909();
    }

    @Override
    public final void renderLayer(PonderLevel world, class_4597 buffer, class_11515 type, class_4587 poseStack, float pt) {
        poseStack.method_22903();
        float currentFade = applyFade(poseStack, pt);
        renderLayer(world, buffer, type, poseStack, currentFade, pt);
        poseStack.method_22909();
    }

    @Override
    public final void renderLast(
        class_898 entityRenderManager,
        class_10442 itemModelManager,
        PonderLevel world,
        class_4597 buffer,
        class_11659 queue,
        class_4184 camera,
        class_12075 cameraRenderState,
        class_4587 poseStack,
        float pt
    ) {
        poseStack.method_22903();
        float currentFade = applyFade(poseStack, pt);
        renderLast(entityRenderManager, itemModelManager, world, buffer, queue, camera, cameraRenderState, poseStack, currentFade, pt);
        poseStack.method_22909();
    }

    protected float applyFade(class_4587 ms, float pt) {
        float currentFade = fade.getValue(pt);
        if (fadeVec != null) {
            class_243 scaled = fadeVec.method_1021(-1 + currentFade);
            ms.method_22904(scaled.field_1352, scaled.field_1351, scaled.field_1350);
        }

        return currentFade;
    }

    protected void renderLayer(PonderLevel world, class_4597 buffer, class_11515 type, class_4587 ms, float fade, float pt) {
    }

    protected void renderFirst(
        class_824 blockEntityRenderDispatcher,
        class_776 blockRenderManager,
        PonderLevel world,
        class_4597 buffer,
        class_11659 queue,
        class_4184 camera,
        class_12075 cameraRenderState,
        class_4587 ms,
        float fade,
        float pt
    ) {
    }

    protected void renderLast(
        class_898 entityRenderManager,
        class_10442 itemModelManager,
        PonderLevel world,
        class_4597 buffer,
        class_11659 queue,
        class_4184 camera,
        class_12075 cameraRenderState,
        class_4587 ms,
        float fade,
        float pt
    ) {
    }

    protected int lightCoordsFromFade(float fade) {
        int light = class_765.field_32767;
        if (fade != 1) {
            light = (int) (class_3532.method_48781(fade, 5, 0xF));
            light = class_765.method_23687(light, light);
        }
        return light;
    }

}