package com.zurrtum.create.client.ponder.foundation.element;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.TextElementBuilder;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.PonderScene.SceneTransform;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;

public class TextWindowElement extends AnimatedOverlayElementBase {

    public static final Couple<Color> COLOR_WINDOW_BORDER = Couple.create(new Color(0x607a6000, true), new Color(0x207a6000, true))
        .map(Color::setImmutable);

    Supplier<String> textGetter = () -> "(?) No text was provided";
    @Nullable String bakedText;

    // from 0 to 200
    int y;

    @Nullable class_243 vec;

    boolean nearScene = false;
    PonderPalette palette = PonderPalette.WHITE;

    public TextElementBuilder builder(PonderScene scene) {
        return new Builder(scene);
    }

    private class Builder implements TextElementBuilder {

        private final PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        @Override
        public Builder colored(PonderPalette color) {
            TextWindowElement.this.palette = color;
            return this;
        }

        @Override
        public Builder pointAt(class_243 vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        @Override
        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        @Override
        public Builder text(String defaultText) {
            textGetter = scene.registerText(defaultText);
            return this;
        }

        @Override
        public TextElementBuilder text(String defaultText, Object... params) {
            textGetter = scene.registerText(defaultText, params);
            return this;
        }

        @Override
        public Builder sharedText(class_2960 key) {
            textGetter = () -> PonderIndex.getLangAccess().getShared(key);
            return this;
        }

        @Override
        public TextElementBuilder sharedText(class_2960 key, Object... params) {
            textGetter = () -> PonderIndex.getLangAccess().getShared(key, params);
            return this;
        }

        @Override
        public Builder sharedText(String key) {
            return sharedText(class_2960.method_60655(scene.getNamespace(), key));
        }

        @Override
        public TextElementBuilder sharedText(String key, Object... params) {
            return sharedText(class_2960.method_60655(scene.getNamespace(), key), params);
        }

        @Override
        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        @Override
        public Builder attachKeyFrame() {
            scene.builder().addLazyKeyframe();
            return this;
        }
    }

    @Override
    public void render(PonderScene scene, PonderUI screen, class_332 graphics, float partialTicks, float fade) {
        if (bakedText == null)
            bakedText = textGetter.get();

        if (fade < 1 / 16f)
            return;
        SceneTransform transform = scene.getTransform();
        class_241 sceneToScreen = vec != null ? transform.sceneToScreen(vec, partialTicks) : new class_241(
            screen.field_22789 / 2f,
            (screen.field_22790 - 200) / 2f + y - 8
        );

        boolean settled = transform.xRotation.settled() && transform.yRotation.settled();
        float pY = settled ? (int) sceneToScreen.field_1342 : sceneToScreen.field_1342;

        float yDiff = (screen.field_22790 / 2f - sceneToScreen.field_1342 - 10) / 100f;
        float targetX = (screen.field_22789 * class_3532.method_16439(yDiff * yDiff, 6f / 8, 5f / 8));

        if (nearScene)
            targetX = Math.min(targetX, sceneToScreen.field_1343 + 50);

        if (settled)
            targetX = (int) targetX;

        int textWidth = (int) Math.min(screen.field_22789 - targetX, 180);

        class_327 fontRenderer = screen.getFontRenderer();
        List<class_5348> lines = fontRenderer.method_27527().method_27498(bakedText, textWidth, class_2583.field_24360);

        int boxWidth = 0;
        for (class_5348 line : lines)
            boxWidth = Math.max(boxWidth, fontRenderer.method_27525(line));

        int boxHeight = fontRenderer.method_44378(class_2561.method_43470(bakedText), boxWidth);

        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(0, pY);

        new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT).gradientBorder(COLOR_WINDOW_BORDER).at(targetX - 10, 3, -101)
            .withBounds(boxWidth, boxHeight - 1).render(graphics);

        Color brighter = palette.getColorObject().mixWith(new Color(0xff_ffffdd), 0.5f).setImmutable();
        Color c1 = new Color(0xff_494949);
        Color c2 = new Color(0xff_393939);
        if (vec != null) {
            poseStack.pushMatrix();
            poseStack.translate(sceneToScreen.field_1343, 0);
            double lineTarget = (targetX - sceneToScreen.field_1343) * fade;
            poseStack.scale((float) lineTarget, 1);
            graphics.method_25296(0, 0, 1, 1, brighter.getRGB(), brighter.getRGB());
            graphics.method_25296(0, 1, 1, 2, c1.getRGB(), c2.getRGB());
            poseStack.popMatrix();
        }

        for (int i = 0; i < lines.size(); i++) {
            graphics.method_51433(
                fontRenderer,
                lines.get(i).getString(),
                (int) (targetX - 10),
                3 + 9 * i,
                brighter.scaleAlphaForText(fade).getRGB(),
                false
            );
        }
        poseStack.popMatrix();
    }

    public PonderPalette getPalette() {
        return palette;
    }

}