package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.PonderSceneElement;
import com.zurrtum.create.client.ponder.foundation.PonderScene;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_243;

public class AnimateElementInstruction<T extends PonderSceneElement> extends TickingInstruction {

    protected class_243 deltaPerTick;
    protected class_243 totalDelta;
    protected class_243 target;
    protected ElementLink<T> link;
    protected T element;

    private final BiConsumer<T, class_243> setter;
    private final Function<T, class_243> getter;

    protected AnimateElementInstruction(ElementLink<T> link, class_243 totalDelta, int ticks, BiConsumer<T, class_243> setter, Function<T, class_243> getter) {
        super(false, ticks);
        this.link = link;
        this.setter = setter;
        this.getter = getter;
        this.deltaPerTick = totalDelta.method_1021(1d / ticks);
        this.totalDelta = totalDelta;
        this.target = totalDelta;
    }

    @Override
    protected final void firstTick(PonderScene scene) {
        super.firstTick(scene);
        element = scene.resolve(link);
        if (element == null)
            return;
        target = getter.apply(element).method_1019(totalDelta);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (element == null)
            return;
        if (remainingTicks == 0) {
            setter.accept(element, target);
            setter.accept(element, target);
            return;
        }
        setter.accept(element, getter.apply(element).method_1019(deltaPerTick));
    }

}