package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.ParticleEmitter;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import net.minecraft.class_243;
import net.minecraft.class_5819;

public class EmitParticlesInstruction extends TickingInstruction {

    private final class_243 anchor;
    private final ParticleEmitter emitter;
    private final float runsPerTick;

    public EmitParticlesInstruction(class_243 anchor, ParticleEmitter emitter, float runsPerTick, int ticks) {
        super(false, ticks);
        this.anchor = anchor;
        this.emitter = emitter;
        this.runsPerTick = runsPerTick;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        int runs = (int) runsPerTick;
        PonderLevel world = scene.getLevel();
        class_5819 random = world.field_9229;
        if (random.method_43057() < (runsPerTick - runs))
            runs++;
        for (int i = 0; i < runs; i++)
            emitter.create(world, anchor.field_1352, anchor.field_1351, anchor.field_1350);
    }

}