package com.zurrtum.create.client.ponder.foundation.registration;

import com.zurrtum.create.client.ponder.api.registration.MultiTagBuilder;
import com.zurrtum.create.client.ponder.api.registration.PonderTagRegistrationHelper;
import com.zurrtum.create.client.ponder.api.registration.TagBuilder;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import com.zurrtum.create.client.ponder.foundation.registration.GenericMultiTagBuilder.Component;
import com.zurrtum.create.client.ponder.foundation.registration.GenericMultiTagBuilder.Tag;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;

public class DefaultPonderTagRegistrationHelper implements PonderTagRegistrationHelper<class_2960> {

    protected String namespace;
    protected PonderTagRegistry tagRegistry;
    protected PonderLocalization localization;

    public DefaultPonderTagRegistrationHelper(String namespace, PonderTagRegistry tagRegistry, PonderLocalization localization) {
        this.namespace = namespace;
        this.tagRegistry = tagRegistry;
        this.localization = localization;
    }

    @Override
    public <T> PonderTagRegistrationHelper<T> withKeyFunction(Function<T, class_2960> keyGen) {
        return new GenericPonderTagRegistrationHelper<>(this, keyGen);
    }

    @Override
    public TagBuilder registerTag(class_2960 location) {
        return new PonderTagBuilder(location, this::finishTagRegister);
    }

    @Override
    public TagBuilder registerTag(String id) {
        return new PonderTagBuilder(class_2960.method_60655(namespace, id), this::finishTagRegister);
    }

    private void finishTagRegister(PonderTagBuilder builder) {
        localization.registerTag(builder.id, builder.title, builder.description);

        PonderTag tag = new PonderTag(builder.id, builder.textureIconLocation, builder.itemIcon, builder.mainItem);
        tagRegistry.registerTag(tag);

        if (builder.addToIndex)
            tagRegistry.listTag(tag);
    }

    @Override
    public void addTagToComponent(class_2960 component, class_2960 tag) {
        tagRegistry.addTagToComponent(tag, component);
    }

    @Override
    public MultiTagBuilder.Tag<class_2960> addToTag(class_2960 tag) {
        return new GenericMultiTagBuilder<class_2960>().new Tag(this, List.of(tag));
    }

    @Override
    public MultiTagBuilder.Tag<class_2960> addToTag(class_2960... tags) {
        return new GenericMultiTagBuilder<class_2960>().new Tag(this, List.of(tags));
    }

    @Override
    public MultiTagBuilder.Component addToComponent(class_2960 component) {
        return new GenericMultiTagBuilder<class_2960>().new Component(this, List.of(component));
    }

    @Override
    public MultiTagBuilder.Component addToComponent(class_2960... components) {
        return new GenericMultiTagBuilder<class_2960>().new Component(this, List.of(components));
    }
}