package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.compat.rei.IngredientHelper;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;

public record DeployingDisplay(
    EntryIngredient input, EntryIngredient target, EntryIngredient output, Optional<class_2960> location
) implements Display {
    public static final DisplaySerializer<DeployingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(DeployingDisplay::input),
            EntryIngredient.codec().fieldOf("target").forGetter(DeployingDisplay::target),
            EntryIngredient.codec().fieldOf("output").forGetter(DeployingDisplay::output),
            class_2960.field_25139.optionalFieldOf("location").forGetter(DeployingDisplay::location)
        ).apply(instance, DeployingDisplay::new)), class_9139.method_56905(
            EntryIngredient.streamCodec(),
            DeployingDisplay::input,
            EntryIngredient.streamCodec(),
            DeployingDisplay::target,
            EntryIngredient.streamCodec(),
            DeployingDisplay::output,
            class_9135.method_56382(class_2960.field_48267),
            DeployingDisplay::location,
            DeployingDisplay::new
        )
    );

    public static DeployingDisplay of(class_8786<?> entry) {
        if (!AllRecipeTypes.CAN_BE_AUTOMATED.test(entry)) {
            return null;
        }
        class_2960 id = entry.comp_1932().method_29177();
        class_1860<?> recipe = entry.comp_1933();
        if (recipe instanceof ItemApplicationRecipe itemApplicationRecipe) {
            return new DeployingDisplay(id, itemApplicationRecipe);
        } else if (recipe instanceof SandPaperPolishingRecipe sandPaperPolishingRecipe) {
            return new DeployingDisplay(id, sandPaperPolishingRecipe);
        }
        return null;
    }

    public DeployingDisplay(class_2960 id, ItemApplicationRecipe recipe) {
        this(
            EntryIngredients.ofIngredient(recipe.ingredient()),
            IngredientHelper.getInputEntryIngredient(recipe.target()),
            EntryIngredients.of(recipe.result()),
            Optional.of(id)
        );
    }

    public DeployingDisplay(class_2960 id, SandPaperPolishingRecipe recipe) {
        this(
            EntryIngredients.ofItemTag(AllItemTags.SANDPAPER),
            EntryIngredients.ofIngredient(recipe.ingredient()),
            EntryIngredients.of(recipe.result()),
            Optional.of(id)
        );
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input, target);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.DEPLOYING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
